---
id: 65ca089e848eca0672b9cd77
title: Step 45
challengeType: 20
dashedName: step-45
---

# --description--

Now, back to the `_delete` method, you have to choose the successor, using the `_min_value` helper function.

Add a `_min_value` call after your `elif` block, passing `node.right` as the argument. Assign it to the current node key.

# --hints--

You should assign `self._min_value(node.right)` to `node.key` after your `elif` block.

```js
({ test: () => (runPython(`
import ast

assign_after_elif = _Node(_code).find_class("BinarySearchTree").find_function("_delete").find_ifs()[1].tree.orelse[0].orelse[1]
assign_code = ast.get_source_segment(_code, assign_after_elif)
assert _Node(assign_code).is_equivalent("node.key = self._min_value(node.right)")`)) })
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

--fcc-editable-region--
    def _delete(self, node, key):
        if node is None:
            return node
        if key < node.key:
            node.left = self._delete(node.left, key)
        elif key > node.key:
            node.right = self._delete(node.right, key) 
        else:
            if node.left is None:
                return node.right
            elif node.right is None:
                return node.left   
            
--fcc-editable-region--
    def _min_value(self, node):
        while node.left is not None:
            node = node.left
        return node.key

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

# print('Search for 80:', bst.search(80))



```
