---
id: 65ca0a1f27596a089b0363b9
title: Step 49
challengeType: 20
dashedName: step-49
---

# --description--

Inside the `delete` method, delete `pass` and call the helper method `_delete` with the root of the Binary Search Tree and the key to delete as the arguments.

Also, assign the result of  the `_delete` method to `self.root` in the `delete` method.

# --hints--

You should remove the `pass` keyword from the `delete` method.

```js
({ test: () => {
  assert.isFalse(runPython(`_Node(_code).find_class("BinarySearchTree").find_function("delete").has_pass()`))
}})
```

Your `delete` method should call the `_delete` method with two arguments: `self.root` and `key`.

```js
({ test: () => assert.match(code, /self\._delete\(\s*self\.root\s*,\s*key\s*\)/) });
```

You should assign the result of the `_delete` method to `self.root` in the `delete` method.

```js
const after_split = code.split('def delete(self, key):')[1];
assert.match(after_split, /self\.root\s*=\s*self\._delete\(self\.root,\s*key\)/);
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

    def _delete(self, node, key):
        if node is None:
            return node
        if key < node.key:
            node.left = self._delete(node.left, key)
        elif key > node.key:
            node.right = self._delete(node.right, key) 
        else:
            if node.left is None:
                return node.right
            elif node.right is None:
                return node.left   
            
            node.key = self._min_value(node.right)
            node.right = self._delete(node.right, node.key)   
        
        return node
    
    def _min_value(self, node):
        while node.left is not None:
            node = node.left
        return node.key
        
--fcc-editable-region--
    def delete(self, key):
        pass        

--fcc-editable-region--

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

# print('Search for 80:', bst.search(80))


```
