---
id: 65d8a6fcb15a3a239ba35dfd
title: Step 46
challengeType: 20
dashedName: step-46
---

# --description--

After finding the minimum value, you will need to recursively delete the node with the minimum value from the right subtree.

This step ensures that the node with the minimum value is removed from the tree while maintaining the binary search tree (BST) property.

Call the `_delete` method recursively with `node.right` and `node.key` as the arguments. Assign the return value of the `_delete()` call to the right child of the current node.

# --hints--

You should call the `_delete` method recursively with `node.right` and `node.key` as the arguments.

```js
assert.match(code, /self\._delete\(\s*node\.right\s*,\s*node\.key\s*/);
```

You should assign the return value of the `_delete()` call to the right child of the current node.

```js
assert.match(code, /node\.right\s*=\s*self\._delete\(\s*node\.right\s*,\s*node\.key/);
```

# --seed--

## --seed-contents--

```py

class TreeNode:

    def __init__(self, key):
        self.key = key
        self.left = None
        self.right = None

    def __str__(self):
        return str(self.key)

class BinarySearchTree:

    def __init__(self):
        self.root = None

    def _insert(self, node, key):
        if node is None:
            return TreeNode(key)

        if key < node.key:
            node.left = self._insert(node.left, key)
        elif key > node.key:

            node.right = self._insert(node.right, key)
        return node

    def insert(self, key):
        self.root = self._insert(self.root, key)
        
    def _search(self, node, key):
        if node is None or node.key == key:
            return node
        if key < node.key:
            return self._search(node.left, key)
        return self._search(node.right, key)
    
    def search(self, key):
        return self._search(self.root, key)

--fcc-editable-region--
    def _delete(self, node, key):
        if node is None:
            return node
        if key < node.key:
            node.left = self._delete(node.left, key)
        elif key > node.key:
            node.right = self._delete(node.right, key)
        else:
            if node.left is None:
                return node.right
            elif node.right is None:
                return node.left

            node.key = self._min_value(node.right) 
            
--fcc-editable-region--
    def _min_value(self, node):
        while node.left is not None:
            node = node.left

bst = BinarySearchTree()

nodes = [50, 30, 20, 40, 70, 60, 80]

for node in nodes:
    bst.insert(node)

# print('Search for 80:', bst.search(80))


```
