---
id: 672a55b5c0c14493328fe36e
title: When Is the alt Attribute Needed, and What Are Some Examples of Good Alt Text?
challengeType: 19
dashedName: when-is-the-alt-attribute-needed
---

# --description--

Alternative text, often abbreviated as `alt` text, is a brief text description of an image. It provides essential information about the image for users who cannot see it, such as people who use screen readers and other assistive technologies.

It's essential for making websites accessible to people with visual disabilities.

Alternative text is also used by search engines to understand images. Some browsers may also display it when an image is not loaded properly. This can happen when the image file is missing or when the user has connectivity issues. So it's helpful for many different purposes.

A person with a visual disability will not be able to know what's in the image unless it's described in the alt text. An example of bad alt text for an image of a puppy would be "A cute puppy."

<img src="https://cdn.freecodecamp.org/curriculum/lecture-transcripts/puppy.png" alt="A cute puppy." />

This text is not specific enough to convey the important details of the image, like what does the puppy look like? Where is the puppy? Are there any important objects around the puppy?

Let's improve this. An example of good alternative text would be: "A black and white puppy with an orange collar lies on its belly in the sand, looking off to the side. A bright orange ball rests near its front paws."

Here you can see this in HTML with an image element, the `alt` attribute, and a more detailed description:

```html
<img src="puppy.png" alt="A black and white puppy with an orange collar lies on its belly in the sand, looking off to the side. A bright orange ball rests near its front paws." />
```

It is important to note that there is no one correct way to write alt text for an image. What you include in your description will depend on the context the picture is used in. For example, if the puppy picture was on a website about dog breeds, you might want to include more specifics about the physical description of the puppy and possibly ignore the fact that the puppy is at the beach playing with an orange ball. Ultimately, the `alt` text you use for an image should reflect the primary purpose for including the image on the page, and the information you provide should give people who can't see the image the necessary details to understand that purpose.

Here we have another example of a beautiful tropical resort. Let's describe it.

<img src="https://cdn.freecodecamp.org/curriculum/lecture-transcripts/resort.jpg" alt="Resort.">

An example of bad `alt` text for this image would be "Resort."

This is too short and it doesn't provide enough information about the image. To improve this description, you could expand it to include the most important elements of the image:

"Tropical resort featuring a swimming pool surrounded by palm trees and bungalows."

You can use the alt attribute in HTML like this:

```html
<img src="resort.png" alt="Tropical resort featuring a swimming pool surrounded by palm trees and bungalows." />
```

Now that you know what makes good and bad `alt` text, let's see some of the best practices.

- You should try to keep `alt` text short. It should be detailed enough to understand the image but not so long that it becomes confusing.
- You should not try to describe every little detail. Focus on the most important aspects of the image.
- Generally, you don't need to start with "image of" or "picture of." You can just start the description directly.
- Also, if there's similar text around the image, you don't need to write it again.
- It's usually recommended to end the alt text with a period for consistency.
- If the image is a link to another page, instead of describing the image itself, the `alt` text should describe what will happen if users click on it.

For example, if your website has a right arrow icon that takes the user to the next page, instead of writing an alt text that only says "right arrow", like in this example, where you can see the alt attribute with this description:

```html
<a href="about.html">
  <img src="arrow-right.png" alt="Right arrow." />
</a>
```

You should write something like this instead, where the `alt` text describes what will happen if users clicks on the image. They will go to the next page.

```html
<a href="about.html">
  <img src="arrow-right.png" alt="Go to next page." />
</a>
```

Only images that convey important information should have `alt` text. If an image is only used for decorative purposes, it should have `null` (empty) `alt` text, so it can be ignored by screen readers and other assistive technologies.

Here is an example of an empty `alt` attribute is empty:

```html
<img src="decorative_image.jpg" alt="" />
```

Every image on your website should have an `alt` attribute, even if it's empty. If you omit the `alt` attribute completely, some screen readers will read the file name instead, which can be distracting for people who use assistive technologies, so this is not recommended.

Finally, before your website is live, you should carefully test if screen readers can read the `alt` text correctly.

Writing effective `alt` text is essential for creating accessible web content. As a web developer, by providing clear descriptions of your images, you can make sure that everyone can engage with your website in an inclusive online experience.

# --questions--

## --text--

What is the purpose of alt text in an image?

## --answers--

To improve the appearance of an image.

### --feedback--

Think about why images should be accessible and why these descriptions are important.

---

To provide a decorative element to the webpage.

### --feedback--

Think about why images should be accessible and why these descriptions are important.

---

To describe the image for people with visual disabilities.

---

To increase website loading speed.

### --feedback--

Think about why images should be accessible and why these descriptions are important.

## --video-solution--

3

## --text--

When is it appropriate to leave the alt text empty for an image?

## --answers--

When the image is purely decorative.

---

When the image is important to understand the content.

### --feedback--

Think about the role of the image on the page.

---

When the image is small.

### --feedback--

Think about the role of the image on the page.

---

Always, to improve website performance.

### --feedback--

Think about the role of the image on the page.

## --video-solution--

1

## --text--

What should be the primary focus of the alt text for an image that acts as a link?

## --answers--

Describing the image visually.

### --feedback--

Think about the purpose of alt text and how it relates to links.

---

Indicating the link's destination.

---

Combining both the image description and link destination.

### --feedback--

Think about the purpose of alt text and how it relates to links.

---

The alt text is not important for images that are links.

### --feedback--

Think about the purpose of alt text and how it relates to links.

## --video-solution--

2
