---
id: 672a55eb7791559421ff0cd3
title: What Are Good Ways to Make Audio and Video Content Accessible?
challengeType: 19
dashedName: what-are-good-ways-to-make-audio-and-video-content-accessible
---

# --interactive--

Multimedia, especially video, has become the go-to format for sharing information online.

With this surge in content, there's a growing need to ensure everyone can access and enjoy video and audio content online, irrespective of their abilities or environment.

Making your audio and video content accessible isn't just a nice-to-have, it's essential for reaching a wider audience. Let's look at some inexpensive ways to make your video and audio content more accessible.

A video is not just about visuals but also audio, so the first thing you should consider doing is adding captions or subtitles to your video content.

Captions provide the text version of spoken words and important non-verbal sounds, like music or laughter, synchronized with the video. 

Subtitles on the other hand are essential for people who don't understand the language you're speaking. This helps not only people who are deaf or hard of hearing but also those watching videos in noisy or quiet environments.

To add captions or subtitles to your video or audio content, you can use the `track` element inside your `video` or `audio` element:

:::interactive_editor

```html
<video
  width="400"
  height="300"
  controls
  src="https://cdn.freecodecamp.org/curriculum/labs/what-is-the-map-method-and-how-does-it-work.mp4"
>
  <track
    src="captions.vtt"
    kind="captions"
    srclang="en"
    label="English"
  />
</video>

<audio controls src="sample.mp3">
  <track
    src="captions.vtt"
    kind="captions"
    srclang="en"
    label="English"
  />
</audio>
```

:::

The `kind` attribute is used to tell the track element how it should be used. Valid values for the `kind` attribute include `captions`, `subtitles`, `chapters`, and `metadata`.

The `srclang` attribute represents the language for the `track` content. The `label` attribute is a descriptive title for the text track that browsers use to identify and display it in the list of available text tracks.

Another important thing to consider is providing a transcript for your audio and video content. A transcript is a text version of all the spoken words in your audio or video. Unlike captions, transcripts don’t need to be synchronized with the media. Transcripts are useful for deaf people and those hard of hearing. They're also beneficial for people who prefer reading instead of watching or listening. Transcripts also make your content searchable, allowing users to quickly find specific parts of your audio or video. If you have a video or audio on a website, you can simply add the transcript below the audio or video:

```html
<audio controls>
  <source src="audio.mp3" />
  Your browser does not support the audio element.
</audio>

<!-- Transcript -->
<h3>Transcript</h3>
<p>
  [Speaker 1]: Welcome to the tutorial on making accessible content
</p>
<p>
  [Speaker 2]: Today, we'll cover captions, transcripts, and more.
</p>

<!-- Rest of transcript -->
```

If you're publishing videos on a video-sharing platform like YouTube or Vimeo, they have automatic captions and transcripts for videos. But if you're not satisfied, you can use services like veed.io, Rev, Amara, and Descript.

Other ways to make your video and audio content accessible include:

- Adding a sign language overlay for videos for deaf people and those hard of hearing.
- Providing volume and speed controls.
- Ensuring good contrast for on-screen text.
- Offering multiple formats.

# --questions--

## --text--

How are captions different from subtitles in video content?

## --answers--

Captions provide translations for non-native speakers.

### --feedback--

Focus on what each feature is intended for and the specific audience it serves.

---

Captions include spoken words and non-verbal sounds, while subtitles are for viewers who don't understand the language.

---

Subtitles include both spoken words and non-verbal sounds, while captions are only for translations.

### --feedback--

Focus on what each feature is intended for and the specific audience it serves.

---

Subtitles are synchronized with the video, but captions are not.

### --feedback--

Focus on what each feature is intended for and the specific audience it serves.

## --video-solution--

2

## --text--

How can you add captions or subtitles directly to your video or audio content in HTML?

## --answers--

By using the `caption` tag inside the `video` or `audio` element.

### --feedback--

Look for the specific HTML tag designed to handle captions and subtitles.

---

By using the `track` tag inside the `video` or `audio` element.

---

By placing the `subtitle` tag within the `video` or `audio` element.

### --feedback--

Look for the specific HTML tag designed to handle captions and subtitles.

---

By embedding a `text` tag inside the `video` or `audio` element.

### --feedback--

Look for the specific HTML tag designed to handle captions and subtitles.

## --video-solution--

2

## --text--

Why are transcripts important for audio and video content?

## --answers--

Transcripts are only useful for people who prefer watching videos.

### --feedback--

Consider the accessibility benefits and the additional functionality that transcripts provide.

---

Transcripts help make content accessible for deaf or hard-of-hearing individuals and allow for easy searching of specific content.

---

Transcripts are solely for translating the spoken language into another language.

### --feedback--

Consider the accessibility benefits and the additional functionality that transcripts provide.

---

Transcripts are used to add non-verbal sounds like music and laughter to the content.

### --feedback--

Consider the accessibility benefits and the additional functionality that transcripts provide.

## --video-solution--

2
