---
id: 672cf07a2b9796eb49719e03
title: What Are Media Breakpoints, and What Are Common Breakpoints in Modern Design?
challengeType: 19
dashedName: what-are-media-breakpoints
---

# --interactive--

Media breakpoints are specific points in a website's design where the layout and content adjust to accommodate different screen sizes. These breakpoints are crucial in responsive web design, allowing developers to create websites that look and function well across various devices, from mobile phones to large desktop monitors.

In CSS, media breakpoints are implemented using media queries. These queries allow you to apply different styles based on the characteristics of the device, most commonly the viewport width. For example, you might set a breakpoint at 768 pixels to differentiate between mobile and tablet layouts.

Here's a simple example of how a media query with a breakpoint might look in CSS:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div>
  <h1>Responsive Design</h1>
  <p>This is a simple example of responsive design using media queries.</p>
</div>
```

```css
/* Styles for screens wider than 768px */
@media screen and (min-width: 768px) {
  body {
    font-size: 1.125rem;
  }
}
```

:::

When the screen width is 768 pixels or larger, the font size increases to `1.125rem` which is 18 pixels. This demonstrates how breakpoints can be used to adjust the design for different screen sizes.

When it comes to choosing breakpoints, there's no one-size-fits-all solution. The appropriate breakpoints for your website will depend on your specific design and content. However, there are some common breakpoints that many designers use as starting points in modern web design.

A popular set of breakpoints corresponds to common device categories:

- Small devices (smartphones): up to 640px.

- Medium devices (tablets): 641px to 1024px.

- Large devices (desktops): 1025px and larger.

Some designers prefer a more granular approach, using breakpoints like:

- Extra small devices: up to 576px.

- Small devices: 577px to 768px.

- Medium devices: 769px to 992px.

- Large devices: 993px to 1200px.

- Extra large devices: 1201px and larger.

It's important to note that these are not strict rules, but rather common practices.

The trend in modern responsive design is moving towards a more fluid approach, where designs adapt smoothly across a wide range of screen sizes, rather than making dramatic changes at set breakpoints.

Here are some other common examples for breakpoints:

- Extra small device: under 576px.

- Small device: more than or equal to 576px.

- Medium device: more than or equal to 768px.

- Large device: more than or equal to 992px.

- Extra large device: more than or equal to 1200px.

- Extra extra large device: more than or equal to 1400px.

These breakpoints are widely used and can serve as a good starting point for many projects. However, it's crucial to remember that the best breakpoints for your project should be determined by your content and design, not by arbitrary numbers or device sizes.

# --questions--

## --text--

What is the primary purpose of media breakpoints in responsive web design?

## --answers--

To change the website's color scheme on different devices.

### --feedback--

Think about how websites adapt to various device sizes.

---

To adjust the layout and content for different screen sizes.

---

To increase the website's loading speed on mobile devices

### --feedback--

Think about how websites adapt to various device sizes.

---

To add new features for desktop users.

### --feedback--

Think about how websites adapt to various device sizes.

## --video-solution--

2

## --text--

Which of the following is a commonly used breakpoint for smaller devices like smart phones?

## --answers--

1640px

### --feedback--

Review the beginning of the lesson to see where this was discussed.

---

640px

---

1200px

### --feedback--

Review the beginning of the lesson to see where this was discussed.

---

2000px

### --feedback--

Review the beginning of the lesson to see where this was discussed.

## --video-solution--

2

## --text--

Which of the following is NOT typically considered a common breakpoint in modern responsive design?

## --answers--

`768px` (tablets).

### --feedback--

Think about which screen resolution is less commonly targeted in responsive designs.

---

`1024px` (small desktops).

### --feedback--

Think about which screen resolution is less commonly targeted in responsive designs.

---

`480px` (large smartphones).

### --feedback--

Think about which screen resolution is less commonly targeted in responsive designs.

---

`6000px` (really large device).

## --video-solution--

4
