---
id: 6874b5fc38f90f25e18093ce
title: What Are Methods and Attributes, and How Do They Work?
challengeType: 19
dashedName: what-are-methods-and-attributes-and-how-do-they-work
---

# --description--

In the last lesson, you learned about classes and how they act as blueprints for creating objects.

Here, we will dive deeper into attributes and methods.

Let's take a closer look at attributes first, then methods.

Attributes are variables that belong to an object, so they hold data. There are two kinds of attributes: instance attributes and class attributes.

Instance attributes are unique to each object created from a class, and you usually set them with the `__init__` method. Class attributes, on the other hand, belong to the class itself and are shared by all instances of that class.

To access an attribute, you use dot notation.

Here are examples of both instance and class attributes, and how to access them from objects:

```python
class Dog:
    species = "French Bulldog" # Class attribute

    def __init__(self, name):
        self.name = name # Instance attribute

print(Dog.species) # French Bulldog

dog1 = Dog("Jack")
print(dog1.name)    # Jack
print(dog1.species) # French Bulldog

dog2 = Dog("Tom")
print(dog2.name)    # Tom
print(dog2.species) # French Bulldog
```

Note that you can access class attributes directly from the class itself, but you need to create an object and pass it data first before you can access instance attributes.

Cars are another good example, since all cars have a model and color:

```python
class Car:
    def __init__(self, color, model):
        self.color = color
        self.model = model

car_1 = Car("red", "Toyota Corolla")
car_2 = Car("green", "Lamborghini Revuelto")

print(car_1.model) # Toyota Corolla
print(car_2.model) # Lamborghini Revuelto

print(car_1.color) # red
print(car_2.color) # green
```

Methods are functions defined inside a class. With them, any object defined from a class can perform actions that operate on or modify its own data. You also access a method with dot notation.

For example, dogs can bark. So we can have a `bark` method in the `Dog` class like you saw in a previous lesson:

```python
class Dog:
   species = "French Bulldog"

   def __init__(self, name):
     self.name = name

   def bark(self):
       return f"{self.name} says woof woof!"

jack = Dog("Jack")
jill = Dog("Jill")

print(jack.bark()) # Jack says woof woof!
print(jill.bark()) # Jill says woof woof!
```

A `Car` class can also have a `describe` method:

```python
class Car:
    def __init__(self, color, model):
        self.color = color  # Instance attribute
        self.model = model  # Instance attribute

    def describe(self):
        return f"This car is a {self.color} {self.model}"

car_1 = Car("red", "Toyota Corolla")
car_2 = Car("green", "Lamborghini Revuelto")

print(car_1.describe()) # This car is a red Toyota Corolla
print(car_2.describe()) # This car is a green Lamborghini Revuelto
```

# --questions--

## --text--

What are the two types of attributes in Python?

## --answers--

Public and private attributes

### --feedback--

Think about the two ways you can define attributes.

---

Local and global attributes

### --feedback--

Think about the two ways you can define attributes.

---

Instance attributes and class attributes

---

Mutable and immutable attributes

### --feedback--

Think about the two ways you can define attributes.

## --video-solution--

3

## --text--

What is required to access instance attributes?

## --answers--

The class name only

### --feedback--

Think about how you access class attributes versus how you access instance attributes.

---

Decorators

### --feedback--

Think about how you access class attributes versus how you access instance attributes.

---

An instance or object of the class

---

A static method

### --feedback--

Think about how you access class attributes versus how you access instance attributes.

## --video-solution--

3

## --text--

How do you define and access methods?

## --answers--

As standalone functions outside a class, accessed with brackets

### --feedback--

They belong to the class but operate on object data.

---

As variables in a class, accessed like attributes

### --feedback--

They belong to the class but operate on object data.

---

With special keywords, called automatically

### --feedback--

They belong to the class but operate on object data.

---

They are defined inside a class and accessed with dot notation

## --video-solution--

4
