---
id: 672b8e9892eafe238d6513a5
title: What Is the Specificity for Class Selectors?
challengeType: 19
dashedName: what-is-the-specificity-for-class-selectors
---

# --interactive--

Class selectors are a key part of CSS, allowing developers to target multiple elements with the same class attribute and apply consistent styling.

This makes them highly versatile and efficient for applying styles across a website.

Class selectors are defined by a period (`.`) followed by the class name. They can be applied to any element in the HTML document.

Here is an example using a class selector:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p class="highlight">Example paragraph</p>
```

```css
.highlight {
  color: green;
}
```

:::

In this example, any element with the class `highlight` will have its text color set to `green`.

Class selectors have a higher specificity than type selectors but lower than ID selectors and inline styles.

The specificity value for a class selector is `(0, 0, 1, 0)`. This means that class selectors can override type selectors, but they can be overridden by ID selectors and inline styles.

Class selectors can be combined with other selectors to create more specific rules.

Here is an example combining a paragraph type selector with a class selector:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<p class="bold-text">Example paragraph</p>
<p class="bold-text">Example paragraph</p>
<p>Another paragraph</p>
<p>Yet another paragraph</p>
```

```css
p.bold-text {
  font-weight: bold;
}
```

:::

This rule applies only to `p` elements that also have the `bold-text` class, making their text bold.

# --questions--

## --text--

What is the specificity value of a class selector (e.g., `.example`)?

## --answers--

(1, 0, 0, 0)

### --feedback--

This selector targets elements with a specific class name.

---

(0, 1, 0, 0)

### --feedback--

This selector targets elements with a specific class name.

---

(0, 0, 1, 0)

---

(0, 0, 0, 1)

### --feedback--

This selector targets elements with a specific class name.

## --video-solution--

3

## --text--

Which of the following selectors has a higher specificity than a class selector?

## --answers--

A type selector.

### --feedback--

This selector targets elements with a unique identifier.

---

An ID selector.

---

A universal selector.

### --feedback--

This selector targets elements with a unique identifier.

---

A pseudo-element.

### --feedback--

This selector targets elements with a unique identifier.

## --video-solution--

2

## --text--

Given the following CSS, what will be the color of the text?

```html
<head>
  <style>
    .highlight {
      color: green;
    }
    p {
      color: blue;
    }
    p.highlight {
      color: red;
    }
  </style>
</head>
<body>
  <p class="highlight">This text</p>
</body>
```

## --answers--

`green`

### --feedback--

Consider the specificity of the combined selectors.

---

`blue`

### --feedback--

Consider the specificity of the combined selectors.

---

`red`

---

`purple`

### --feedback--

Consider the specificity of the combined selectors.

## --video-solution--

3
