---
id: 672b8ea434ceac23cc90f337
title: What Is the Specificity for ID Selectors?
challengeType: 19
dashedName: what-is-the-specificity-for-id-selectors
---

# --interactive--

ID selectors are among the most powerful selectors in CSS, allowing developers to apply styles to specific elements with unique identifiers.

This makes them highly effective for targeting individual elements that need unique styling.

ID selectors are defined by a hash symbol (`#`) followed by the ID name. They should be unique within an HTML document, meaning no two elements should share the same ID.

Here is an example using an ID selector:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<p id="unique">Example paragraph</p>
<p>Another paragraph</p>
<p>Yet another paragraph</p>
```

```css
#unique {
  color: purple;
}
```

:::

In this example, the element with the ID `unique` will have its text color set to `purple`.

ID selectors have a very high specificity, higher than type selectors and class selectors, but lower than inline styles. The specificity value for an ID selector is `(0, 1, 0, 0)`.

This means that ID selectors can override class selectors and type selectors but can be overridden by inline styles.

# --questions--

## --text--

What is the specificity value of an ID selector (e.g., `#example`)?

## --answers--

(1, 0, 0, 0)

### --feedback--

This selector targets elements with a specific, unique identifier.

---

(0, 1, 0, 0)

---

(0, 0, 1, 0)

### --feedback--

This selector targets elements with a specific, unique identifier.

---

(0, 0, 0, 1)

### --feedback--

This selector targets elements with a specific, unique identifier.

## --video-solution--

2

## --text--

Which of the following has a higher specificity than an ID selector?

## --answers--

A class selector.

### --feedback--

Review the last part of the lesson for the answer.

---

An inline style.

---

An attribute selector.

### --feedback--

Review the last part of the lesson for the answer.

---

A type selector.

### --feedback--

Review the last part of the lesson for the answer.

## --video-solution--

2

## --text--

Given the following CSS, what will be the color of the text?

```html
<head>
  <style>
    #unique {
      color: purple;
    }
    .highlight {
      color: green;
    }
    p {
      color: blue;
    }
  </style>
</head>
<body>
  <p id="unique" class="highlight">This text</p>
</body>
```

## --answers--

`green`

### --feedback--

Consider the highest specificity.

---

`blue`

### --feedback--

Consider the highest specificity.

---

`red`

### --feedback--

Consider the highest specificity.

---

`purple`

## --video-solution--

4
