---
id: 672b8f1399cabc2406c3227f
title: What Is the important Keyword, and What Are the Best Practices for Using It?
challengeType: 19
dashedName: what-is-the-important-keyword
---

# --interactive--

The `!important` keyword in CSS is used to give a style rule the highest priority, allowing it to override any other declarations for a property.

When used, it forces the browser to apply the specified style, regardless of the specificity of other selectors.

Let's say you have an HTML paragraph element with inline styles like this:

:::interactive_editor

```html
<p class="para" style="background-color: lightblue; color: black;">
  This is a paragraph.
</p>
```

:::

In this example, the paragraph element has a background color set to `lightblue` and a text color set to `black`.

The CSS file applies the following styles to the paragraph element:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<p class="para" style="background-color: lightblue; color: black;">
  This is a paragraph.
</p>
```

```css
.para {
  background-color: black;
  color: white;
}
```

:::

Since inline styles have a higher precedence than class, ID and type selectors, the black background color and white text color will not be applied to that paragraph element.

To override those inline styles, you can use the `!important` keyword like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<p class="para" style="background-color: lightblue; color: black;">
  This is a paragraph.
</p>
```

```css
.para {
  background-color: black !important;
  color: white !important;
}
```

:::

The `!important` keyword is used after the CSS value and before the semicolon.

Now the paragraph element will have those black and white colors applied because the inline styles are being overridden with the use of the `!important` keyword.

The `!important` keyword in CSS is used to give a style rule the highest priority, effectively overriding other declarations, including those with higher specificity and inline styles.

However, the `!important` keyword does not change the specificity of the CSS selector itself. It simply ensures that the rule with `!important` is applied, even if there are other conflicting rules with higher specificity.

Another appropriate use case for the `!important` keyword is to override styles from third-party libraries or frameworks when you do not have control over the original CSS.

However, overusing the `!important` keyword can lead to difficulties in maintaining and debugging your CSS, as it breaks the natural cascading of styles and can lead to unintended consequences.

So, it is best to use the `!important` keyword sparingly.

# --questions--

## --text--

What does the `!important` keyword do in CSS?

## --answers--

It increases the specificity value of a selector.

### --feedback--

This keyword forces a style to be applied.

---

It applies a style regardless of other rules' specificity.

---

It decreases the specificity value of a selector.

### --feedback--

This keyword forces a style to be applied.

---

It overrides only inline styles.

### --feedback--

This keyword forces a style to be applied.

## --video-solution--

2

## --text--

When should the `!important` keyword be used?

## --answers--

As the primary method for styling elements.

### --feedback--

Think about maintainability and debugging.

---

To override third-party styles or as a temporary fix.

---

In every CSS rule for consistency.

### --feedback--

Think about maintainability and debugging.

---

To increase specificity.

### --feedback--

Think about maintainability and debugging.

## --video-solution--

2

## --text--

Given the following CSS, what will be the color of the text?

```html
<head>
  <style>
    p {
      color: blue;
    }
    .highlight {
      color: green !important;
    }
    #unique {
      color: purple;
    }
  </style>
</head>
<body>
  <p id="unique" class="highlight">This text</p>
</body>
```

## --answers--

`blue`

### --feedback--

Consider the impact of the `!important` keyword.

---

`green`

---

`purple`

### --feedback--

Consider the impact of the `!important` keyword.

---

`red`

### --feedback--

Consider the impact of the `!important` keyword.

## --video-solution--

2
