---
id: 672b8f23511adf25646b4236
title: How Does the Cascade Algorithm Work at a High Level?
challengeType: 19
dashedName: how-does-the-cascade-algorithm-work-at-a-high-level
---

# --interactive--

The Cascade Algorithm is the process the browser uses to decide which CSS rules to apply when there are multiple styles targeting the same element. It ensures that the most appropriate styles are used, based on a set of well-defined rules.

The process begins with **relevance**. The browser first filters all the CSS rules to find those that actually apply to the element in question. This includes matching selectors and considering media queries that might be in effect.

A media query is a CSS technique used to apply styles based on the characteristics of the device or viewport, such as its width, height, or orientation.

Next, the algorithm considers **origin and importance**. CSS can come from different sources: the browser’s default styles (user-agent), styles set by the user, and styles written by the author (you).

Following the consideration of origin, the algorithm then evaluates the importance of each rule, giving priority to rules marked with `!important`, which override other rules regardless of their source.

After filtering by origin and importance, the algorithm looks at **specificity**. When two rules from the same origin and importance level apply, the rule with the higher specificity will be applied.

Specificity is a measure of how targeted a selector is, with more specific selectors taking precedence over more general ones.

Finally, if everything else is equal, the **order of appearance** comes into play. When two rules have the same specificity, the one that appears last in the CSS will be applied.

This is why the order in which you write your styles can sometimes affect the outcome.

Let's take a look at an example.

In the HTML file, there is a single paragraph element. Then inside the CSS, we have two rules, each targeting the paragraph element.

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<p>example paragraph</p>
```

```css
p {
  color: blue;
}

p {
  color: green; 
}
```

:::

The first rule sets all paragraph elements to the text color of blue while the second rule sets all paragraph elements to the text color of green.

So which color will be applied? The color green will be applied to the paragraph elements.

By considering relevance, origin and importance, specificity, scope, and order of appearance, the Cascade Algorithm ensures that your CSS behaves predictably, allowing you to design more complex and nuanced web pages.

# --questions--

## --text--

What is the first step the Cascade Algorithm takes when determining which styles to apply?

## --answers--

It checks the specificity of the rules.

### --feedback--

Think about how the browser decides which rules could apply to an element.

---

It filters the rules by relevance.

---

It looks for `!important` declarations.

### --feedback--

Think about how the browser decides which rules could apply to an element.

---

It applies the last rule in the CSS.

### --feedback--

Think about how the browser decides which rules could apply to an element.

## --video-solution--

2

## --text--

What will happen if you try to apply a conflicting set of styles to two paragraph rules?

## --answers--

Parts of the styles from each rule will apply.

### --feedback--

Review the end of the lesson where the example was shown for this.

---

The program will crash.

### --feedback--

Review the end of the lesson where the example was shown for this.

---

The last styles will be applied.

---

None of the styles will apply.

### --feedback--

Review the end of the lesson where the example was shown for this.

## --video-solution--

3

## --text--

Which of the following factors does not influence the Cascade Algorithm's decision on which CSS rule to apply?

## --answers--

The specificity of the selectors.

### --feedback--

Consider what the Cascade Algorithm evaluates when resolving style conflicts.

---

The scoping proximity of the rules.

### --feedback--

Consider what the Cascade Algorithm evaluates when resolving style conflicts.

---

Whether the `!important` keyword is used.

### --feedback--

Consider what the Cascade Algorithm evaluates when resolving style conflicts.

---

The `color` property of the CSS rule.

## --video-solution--

4
