---
id: 6733befb703ca6361da3755b
title: What Are Some Examples of Using Advanced JavaScript Debugging Techniques?
challengeType: 19
dashedName: what-are-some-examples-of-using-advanced-javascript-debugging-techniques
---

# --description--

Debugging your JavaScript programs goes beyond using `console.log()` statements in your code. There are more advanced techniques that make debugging a breeze once you get used to them. Let's go through those more advanced techniques so you'll be happy to debug your JavaScript program once you run into errors.

The first concept we will take a look at is working with breakpoints. Breakpoints let you pause the execution of your code at a specific line of your choice. After the pause, you can inspect variables, evaluate expressions, and examine the call stack.

To add a breakpoint to any line in your code in the Chrome browser, open the developer tools and navigate to the Sources tab, open the JavaScript file you want to debug, and click on a line number to set a breakpoint.

After the execution reaches the breakpoint and stops, you can step through the code by using the icons on the top right corner. You can also add a conditional breakpoint by right-clicking on a line and selecting "Add conditional breakpoint…"

Now, let’s move on to watching expressions. Watch expressions lets you monitor the values of variables or expressions as the code runs even if they are out of the current scope.

To add a watch expression, navigate to the Sources tab of the developer tools, look for the watch panel on the right and click the plus (`+`) icon to add it.

The next concept we will look at is profiling. Profiling helps you identify performance bottlenecks by letting you capture screenshots and record CPU usage, function calls, and execution time.

To do that for your code, open the Performance tab, click record, and perform the action you want to profile. After you're done executing that action, stop the recording to analyze the results.

This could be useful if your application is lagging during certain operations. With the profiler, you can see which function or other data in the code consumes the most resources.

Now, let’s move onto inspecting network requests. Inspecting network requests can help you debug issues related to API requests such as parameter errors, address errors, or server errors.

To use the Network tab for debugging, open the developer tools and head over to the Network tab, then click on individual requests to see details like headers, responses, and payloads.

For the last portion of this lesson, we will focus on `console.table` and `console.dir`.

`console.table()` displays tabular data as a table in the console. It takes one mandatory argument, which must be an array or an object, and one optional argument to specify which properties or columns to display.

`console.dir()` on the other hand lets you display an interactive list of the properties of a specified JavaScript object. It outputs a hierarchical listing that can be expanded to see all nested properties.

Now that you have an expanded toolkit of debugging techniques, put these new skills to the test in your upcoming JavaScript projects. By applying these strategies, you'll be able to identify and resolve issues more efficiently, leading to cleaner, more reliable code.

# --questions--

## --text--

In which tab of the Chrome developer tools do you have access to adding breakpoints?

## --answers--

Network tab.

### --feedback--

Think about the tab where you have access to watch expressions and stepping icons.

---

Console tab.

### --feedback--

Think about the tab where you have access to watch expressions and stepping icons.

---

Elements tab.

### --feedback--

Think about the tab where you have access to watch expressions and stepping icons.

---

Sources tab.

## --video-solution--

4

## --text--

What do watch expressions allow you to do?

## --answers--

Monitor only the variables within the current scope.

### --feedback--

Think about tracking variables across different parts of the code.

---

Monitor the values of variables or expressions, even if they are out of the current scope.

---

Automatically fix errors in variables.

### --feedback--

Think about tracking variables across different parts of the code.

---

Change variable values permanently.

### --feedback--

Think about tracking variables across different parts of the code.

## --video-solution--

2

## --text--

What method can you use to see an interactive list of properties for the JavaScript object you pass in?

## --answers--

`console.log()`

### --feedback--

You can use this method directly in your code, and it doesn’t just log data or a table to the console.

---

`console.table()`

### --feedback--

You can use this method directly in your code, and it doesn’t just log data or a table to the console.

---

`console.dir()`

---

Finding the object in the Network tab and double clicking on it.

### --feedback--

You can use this method directly in your code, and it doesn’t just log data or a table to the console.

## --video-solution--

3
