---
id: 67083868d5fdcb17bf8c14bd
title: What Are HTML Entities, and What Are Some Common Examples?
challengeType: 19
dashedName: what-are-html-entities
---

# --interactive--

An HTML entity, or character reference, is a set of characters used to represent a reserved character in HTML. 

Let's say you wanted to display the text `This is an <img/> element` on the screen. If you use the code currently in the editor, it won't display the desired result. Even if you added `src` and `alt` attributes to the example, it would show an image in the middle of the paragraph. Not the desired result. To interact with the example, you will need to enable the interactive editor.


:::interactive_editor

```html
<p>This is an <img /> element</p>
```

:::

When the HTML parser sees the less than (`<`) symbol followed by an HTML tag name, it interprets that as an HTML element. That is why you are not getting the desired result of `This is an <img/> element` on the screen.

To fix this issue, you can use HTML entities. Here is an updated example using the correct HTML entities for the less (`<`) than and greater than (`>`) symbols. Now you should see `This is an <img/> element` on the screen.

Enable the interactive editor and try adding a `&lt;p&gt;learning is fun&lt;/p&gt;` below the paragraph element. You should see `<p>learning is fun</p>` on the screen.

:::interactive_editor

```html
<p>This is an &lt;img /&gt; element</p>

```

:::

These types of character references are known as named character references. Named references start with an ampersand sign (`&`) and end with a semicolon (`;`). By using a named character reference, the HTML parser will not confuse this with an actual HTML element. 

Another type of character reference would be the decimal numeric reference. This character reference starts with an ampersand sign and hash symbol (`#`), followed by one or more decimal digits, followed by a semicolon.

Here is an example of using the decimal numeric reference for the less than symbol. 

Enable the interactive editor and change the code to see different symbols. You can use `&#169;` for the copyright symbol and `&#174;` for the trademark symbol.

:::interactive_editor

```html
&#60;
```

:::

The last type of character reference would be the hexadecimal numeric reference. This character reference starts with an ampersand sign, hash symbol, and the letter `x`. Then it is followed by one or more ASCII hex digits and ends with a semicolon.

Here is an example of using the hexadecimal numeric reference for the less than symbol.

Enable the interactive editor and change the code to see different symbols. You can use `&#x20AC;` for the euro symbol and `&#x03A9;` for the Greek capital letter Omega symbol.

:::interactive_editor

```html
&#x3C;
```

:::


# --questions--

## --text--

What is an HTML entity (character reference)?

## --answers--

A set of Google fonts.

### --feedback--

Remember that HTML has reserved characters, so you will need to use another way to write reserved characters like the less than and greater than symbols.

---

A group of images and captions.

### --feedback--

Remember that HTML has reserved characters, so you will need to use another way to write reserved characters like the less than and greater than symbols.

---

A set of characters used to represent JavaScript code.

### --feedback--

Remember that HTML has reserved characters, so you will need to use another way to write reserved characters like the less than and greater than symbols.

---

A set of characters used to represent a reserved character in HTML.

## --video-solution--

4

## --text--

What are the three types of character references?

## --answers--

Named, Roman and Hexadecimal numeric character references.

### --feedback--

Please refer back to where the different types of character references are talked about in detail.

---

Octal, Named and Binary character references.

### --feedback--

Please refer back to where the different types of character references are talked about in detail.

---

Named, Decimal numeric, and Hexadecimal numeric character references.

---

Asymmetric, Decimal numeric, and Hexadecimal numeric character references.

### --feedback--

Please refer back to where the different types of character references are talked about in detail.

## --video-solution--

3

## --text--

Which of the following is the correct syntax for a named character reference?

## --answers--

`&amp;`

---

`;amp;`

### --feedback--

Refer back to where there are examples for named references.

---

`&amp>>`

### --feedback--

Refer back to where there are examples for named references.

---

`&amp&`

### --feedback--

Refer back to where there are examples for named references.

## --video-solution--

1
