---
id: 670838b10ee87a18e5faff62
title: What Is the Role of the Script Element in HTML, and How Can It Be Used to Link to External JavaScript Files?
challengeType: 19
dashedName: what-is-the-role-of-the-script-element-in-html
---

# --interactive--

The `script` element is used to embed executable code. Most developers will use this to execute JavaScript code. JavaScript is used to add interactivity to your web pages. Common examples of using JavaScript include interactive games, image sliders, and dynamic forms that validate user input in real-time. 

Here is an example of using the `script` element in an HTML document. Remove the `//` from in front of the `alert("Welcome to freeCodeCamp");` and you should see an alert pop up. To see the previews, you will need to enable the interactive editor.

:::interactive_editor

```html
<body>
  <script>
    // alert("Welcome to freeCodeCamp");
  </script>
</body>
```

:::

While you can technically write all of your JavaScript code inside the `script` tags, it is considered best practice to link to an external JavaScript file instead. Here is an example of using the `script` element to link to an external JavaScript file:

```html
<script src="path-to-javascript-file.js"></script>
```

The `src` attribute is used here to specify the location for that external JavaScript file. `src` stands for "source". The reason why it is not encouraged to place all of your JavaScript inside the HTML document is because of separation of concerns. Separation of concerns is a design principle where you separate your programs into distinct sections and have each section address a separate concern. In this case, we want to separate our JavaScript code from our HTML code.

# --questions--

## --text--

Which attribute is used to link to an external JavaScript file?

## --answers--

The `div` attribute.

### --feedback--

Look out for the attribute that specifies the JavaScript file location/

---

The `defer` attribute.

### --feedback--

Look out for the attribute that specifies the JavaScript file location.

---

The `async` attribute.

### --feedback--

Look out for the attribute that specifies the JavaScript file location.

---

The `src` attribute.

## --video-solution--

4

## --text--

What is separation of concerns?

## --answers--

It's about making sure everyone on the team has their own clear responsibilities.

### --feedback--

Review where separation of concerns was discussed.

---

A design principle where you separate your programs into distinct sections and have each section address a separate concern.

---

The act of combining all aspects of a program into a single module for simplicity.

### --feedback--

Review where separation of concerns was discussed.

---

It involves dividing up tasks among team members without considering how they might overlap or affect each other.

### --feedback--

Review where separation of concerns was discussed.

## --video-solution--

2

## --text--

Which of the following is the correct syntax for linking to an external JavaScript file? 

## --answers--

`<script div="path-to-javascript-file.js"></script>`

### --feedback--

Review where linking to external files was discussed.

---

`<script alt="path-to-javascript-file.js"></script>`

### --feedback--

Review where linking to external files was discussed.

---

`<script src="path-to-javascript-file.js"></script>`

---

`<script defer="path-to-javascript-file.js"></script>`

### --feedback--

Review where linking to external files was discussed.

## --video-solution--

3
