---
id: 672a51e9e4fd8b8552eeb758
title: What Is Accessibility?
challengeType: 19
dashedName: what-is-accessibility
---

# --description--

Accessibility involves creating products and services that everyone can use. In the context of web development, it's making websites that everyone can understand and interact with, including people with visual, auditory, motor, and cognitive disabilities.

Some examples of disabilities that can impact users' online experience include:

- Blindness.
- Low vision.
- Color blindness.
- Deafness.
- Difficulty using keyboards, mice, or touchscreens.
- Attention disorders
- Memory issues.
- Difficulty speaking or understanding spoken language.
- Sensitivity to flashing lights.

These are just a few of many conditions that can impact users around the world.

To help you create accessible websites, the World Wide Web Consortium, known as W3C, developed a set of international standards that you can follow to make your websites more accessible and easier to use for people with disabilities.

These standards are known as the "Web Content Accessibility Guidelines" (WCAG).

These guidelines are designed with four core principles in mind, known as **POUR**.

- `P` stands for Perceivable. Users must be able to perceive the information that you are presenting. For example, you can provide alternative text for images, so users who access your website with a screen reader can understand them.
- `O` stands for Operable. Users must be able to interact with the user interface. For example, you can make sure that all functionality is accessible through the keyboard too, not just the mouse.
- `U` stands for Understandable. Users must be able to understand the information. For example, you can avoid complex sentences and use simple language as much as possible.
- `R` stands for Robust. A wide range of browsers and other tools, including assistive technologies, must be able to interpret the content. 

Using semantic HTML is very helpful for making your website compatible with different browsers and assistive technologies.

If your content doesn't follow any one of these core principles, not everyone will be able to use your website.

To check if you are following these guidelines correctly, you can access the Quick Reference of the World Wide Web Consortium. There, you will find a comprehensive list of criteria and techniques.

Accessibility is essential for web development. By developing with inclusivity in mind, you can ensure that everyone can access and engage with your content, promote equality and create a better user experience for everyone around the world.


# --questions--

## --text--

What is the primary goal of web accessibility?

## --answers--

To make websites look better.

### --feedback--

Think about why you should make websites accessible.

---

To ensure websites are usable by everyone.

---

To improve website performance.

### --feedback--

Think about why you should make websites accessible.

---

To increase website traffic.

### --feedback--

Think about why you should make websites accessible.

## --video-solution--

2

## --text--

What are the Web Content Accessibility Guidelines (WCAG)?

## --answers--

A programming language for web development.

### --feedback--

Think about why you should make websites inclusive.

---

A set of guidelines for making websites accessible to everyone.

---

A new design trend for websites.

### --feedback--

Think about why you should make websites inclusive.

---

A tool for testing website performance.

### --feedback--

Think about why you should make websites inclusive.

## --video-solution--

2

## --text--

Which of the following is NOT a core principle of the Web Content Accessibility Guidelines (WCAG)?

## --answers--

Perceivable.

### --feedback--

Think about the essential principles of an accessible website, the guidelines that online content should follow.

---

Operable.

### --feedback--

Think about the essential principles of an accessible website, the guidelines that online content should follow.

---

Understandable.

### --feedback--

Think about the essential principles of an accessible website, the guidelines that online content should follow.

---

Compatible.

## --video-solution--

4
