---
id: 68828e965f70137025ec5031
title: What Is Version Control, and Why Are These Systems Necessary?
challengeType: 19
dashedName: what-is-version-control-and-why-are-these-systems-necessary
---

# --description--

If you've worked on something, like a thesis paper, where you've saved copies after making significant changes and named the files something like `Thesis-Draft`, `Thesis-Final`, `Thesis-Final-For-Real`, and `Thesis-Absolute-Final-DO-NOT-CHANGE`, you've used a very rudimentary approach to version control. But what if I told you there is a better way?

You may have heard of tools like Git, SVN, or Mercurial before. These are version control systems, and they are a key component to every developer's workflow. A version control system allows you to track and manage changes in your project. For the purposes of these lessons, we will be focusing on Git.

Git offers powerful tools that allow you to manage the edit history of a project. You will learn more about how to use Git and the features it offers in upcoming lessons. For now, here's what you really need to know:

Git allows you to do things like create commits, which are a snapshot of a specific state of your codebase. You can then compare commits to see what changes you have made, revert a commit that has improper changes, and more.

You can also create "branches", which you can think of as different pathways in your code. While a branch might be the road you walk down, commits are the landmarks along the way. Branches allow you to do things like work on a new feature in isolation, such that if your work goes sideways you can delete the branch without impacting the core codebase.

These features make version control an essential component of collaboration with other developers. When you have multiple people working in the same project, branches allow each of them to work on their own code without running over each other's changes.

You will often pair a version control system like Git with a version control provider like GitHub or Gitlab, which offers you additional collaboration tools and the ability to back up your projects to the cloud.

But even without a cloud-based storage solution, version control systems can be a game changer for your workflows. No more `THIS-IS-THE-FINAL-COPY-FOREVER` files.

There's a lot of cool information to cover about using these systems, so let's do a deep dive in the next few lessons!

# --questions--

## --text--

What is a commit in Git?

## --answers--

A development branch.

### --feedback--

Think about what Git saves when you make changes to your project.

---

A snapshot of a specific state of your codebase.

---

A cloud backup service.

### --feedback--

Think about what Git saves when you make changes to your project.

---

A collaboration tool for developers.

### --feedback--

Think about what Git saves when you make changes to your project.

## --video-solution--

2

## --text--

Why are branches useful in version control systems like Git?

## --answers--

They automatically fix bugs in your code.

### --feedback--

Consider how branches help when multiple developers work on the same project.

---

They increase the speed of your application.

### --feedback--

Consider how branches help when multiple developers work on the same project.

---

They allow you to work on features in isolation.

---

They provide better encryption for your project files.

### --feedback--

Consider how branches help when multiple developers work on the same project.

## --video-solution--

3

## --text--

Which of the following is NOT mentioned as a version control system in the lesson?

## --answers--

Git

### --feedback--

Review the version control systems mentioned at the beginning of the lesson.

---

SVN

### --feedback--

Review the version control systems mentioned at the beginning of the lesson.

---

Mercurial

### --feedback--

Review the version control systems mentioned at the beginning of the lesson.

---

Docker

## --video-solution--

4
