---
id: 68829061f03543726ea6f318
title: What Is a Repository, and How Do You Create One?
challengeType: 19
dashedName: what-is-a-repository-and-how-do-you-create-one
---

# --description--

We've talked a bit about Git and GitHub, so now we can start to put it all together. In order to do this, you need a repository. But what is a repository? You can think of a repository as a container for a project - if you are working on an app, you would keep the files for that app together in a repository.

Repositories can be local on your computer, or remote on a service like GitHub. To create a repository, you can start with either local or remote - the result will be the same, so take whatever approach fits your workflow best. For a workflow where you start with a remote repository, you can create one directly through GitHub's website by following these instructions:

Visit <a href="https://github.com" target="_blank">GitHub's website</a>, make sure you are logged in, and then click the plus icon in the top right of the navigation bar. You'll see quite a few options, but the one you care about is "New Repository". Select that to open the UI for creating a new repository.

The first option you'll see there is the ability to choose a template. You likely do not have one of these set up yet, but a template is a special kind of repository that you can use as a springboard for your new repositories. These are helpful for including documentation or issue templates in all of your projects.

Your next option is to select on owner, you can choose your user account or any organizations you own or have access to. Then you can name the repository - in general, you'll want to use a name that succinctly describes the project you are building. As a general best practice, you want to avoid spaces in your repo name. GitHub will automatically replace them with hyphens.

Next, you can optionally add a description which will appear on the repository's home page.

You can also choose whether the repository will be public or private. A public repository can be viewed and downloaded by anyone. A private repository can only be accessed by you, and anyone you grant explicit access to.

Finally, if you do not select a template, you will see options to generate files in the repository automatically. A README file will appear on the repository's homepage, and is a great way to provide documentation and descriptions of your project. A `.gitignore` file allows you to specify files that Git will "ignore" - this is great for things like package dependencies, environment files, and other things you don't want to be saved. GitHub will offer templates for this file, which exclude the common items for the specified language or runtime. And a license is a legal document which outlines who may use your software, and what they may do with it.

When you have your settings all configured as you like, you can click the "Create Repository" button to finish the process. You'll automatically be redirected to the landing page for your new repository!

From here, you can click the "Code" button to get options to clone your repository to your computer.

You can ignore the "Codespaces" and "Copilot" tabs for this lesson. Instead, we are going to focus on the three options in the "Local" tab. The first two, HTTPS and SSH, are used in the same way. You use the `git clone` command with the URL provided in the box to clone the remote repository to your computer. The difference between these two is the connection and authentication methods.

For cloning a public repository, you won't actually need to authenticate. But to clone a private repository, or to push to either public or private repositories, you will have to be authenticated. An HTTPS remote URL used to authenticate you via your GitHub username and password. However, due to security concerns this is no longer supported, and you are instead required to use a username and access token. Even then, it's a much less secure method than SSH, which uses your private and public keys. This has an added benefit of automatically signing you in, rather than having to provide a token every time. There will be a separate lesson diving deeper into SSH and how it works but you can also read through the GitHub documentation on how to setup SSH.

To clone the repository, you can run this in the terminal:

```sh
git clone git@github.com:your-username/your-repository-name
```

It will create a folder on your computer with your repository name and contain all the files from your repository within it. From there you can `cd` (change directory) to your cloned repository with:

```sh
cd name-of-cloned-repo
```

Additionally, the local copy of your repo will have a remote pointing to the copy on GitHub. To check your remotes you can run the following command:

```sh
git remote -v
```

Another option for cloning your repository is to use the GitHub CLI. This tool is used to do GitHub-specific tasks without leaving the command line. If you do not have it installed, you can get instructions to do so from GitHub's documentation - but you should have it available in your system's package manager.

To clone a repository with the CLI tool, I would use:

```sh
gh repo clone your-username/your-repository-name
```

The end result of these commands is the same: you'll have a copy of your repository locally.

You can also use the GitHub CLI to create a repository:

```sh
gh repo create
```

If you don't pass any arguments, the CLI will give you an interactive wizard to set up your repository. This wizard will give you all of the same options as the web UI. With this tool, you will also get the option to clone the new repository immediately, so you won't have to go through the manual steps outlined earlier.

You now have a basic understanding of how repositories work, and how you can create one to start properly versioning your work. In future lessons, you will learn how to push an existing local repository to GitHub and how to push changes to remote repositories.

# --questions--

## --text--

What does a repository primarily function as in Git?

## --answers--

A tool for automatically formatting code.

### --feedback--

Think about the fundamental purpose of repositories in version control.

---

A container for a project and its files.

---

A backup system for your computer.

### --feedback--

Think about the fundamental purpose of repositories in version control.

---

A collaboration platform for team meetings.

### --feedback--

Think about the fundamental purpose of repositories in version control.

## --video-solution--

2

## --text--

When creating a repository on GitHub, which of the following is NOT an automatic file generation option?

## --answers--

A README file.

### --feedback--

Review the automatic file generation options mentioned in the lesson.

---

A `.gitignore` file.

### --feedback--

Review the automatic file generation options mentioned in the lesson.

---

A license file.

### --feedback--

Review the automatic file generation options mentioned in the lesson.

---

A `package.json` file.

## --video-solution--

4

## --text--

Which of the following Git commands is used to clone a remote repository to your local computer?

## --answers--

`git cloned`

### --feedback--

Review the last part of the lesson.

---

`git clones`

### --feedback--

Review the last part of the lesson.

---

`git clone`

---

`git cloning`

### --feedback--

Review the last part of the lesson.

## --video-solution--

3
