---
id: 674ba6876f7ada867135bb95
title: How Can You Import and Export Components in React?
challengeType: 19
dashedName: how-can-you-import-and-export-components-in-react
---

# --description--

In earlier lessons, you learned how to work with imports and exports in JavaScript. In this lesson, we will take a look at how to import and export components in React.

In this example, we have a `Cat` component that belongs in a file called `Cat.jsx`. For the file extension, we are using the `.jsx` file extension because this file is mainly working with JSX.

This `Cat` component returns a JSX markup with a title and image for a cat called Mr. Whiskers:

```jsx
function Cat() {
  return (
    <div className="card">
      <h2>Mr. Whiskers</h2>
      <img
        src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg"
        alt="Tuxedo cats running on dirt ground."
      />
    </div>
  );
}
```

If we want to use our `Cat` component in another file, we need to first export it like this:

```jsx
function Cat() {
  return (
    <div className="card">
      <h2>Mr. Whiskers</h2>
      <img
        src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg"
        alt="Tuxedo cats running on dirt ground."
      />
    </div>
  );
}

export default Cat;
```

We are using the `default` keyword because this will be the default export from the module. You can also choose to export the component on the same line as the component definition like this:

```jsx
export default function Cat() {
  return (
    <div className="card">
      <h2>Mr. Whiskers</h2>
      <img
        src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg"
        alt="Tuxedo cats running on dirt ground."
      />
    </div>
  );
}
```

You can choose to import child components in other parent component files, or import them in the root component file. For this example, we will import the `Cat` component inside the root component file.

Every React project will have a top-level component, typically called `App.jsx`:

```jsx
export default function App() {
  return (
    // return component here
  );
}
```

This file is usually located in the `src` directory of your project. You’ll learn more about common project layouts in a future lesson.

To use the `Cat` component inside the root `App` component, you will need to import it like this:

```jsx
import Cat from "./Cat";

export default function App() {
  return (
    // return component here
  );
}
```

Now, you can return the `Cat` component inside the `App` component like this:

```jsx
import Cat from "./Cat";

export default function App() {
  return (
    <Cat />
  );
}
```

As you continue building your own React projects, you’ll become more comfortable organizing components, importing them where needed, and creating sophisticated UIs by composing these modular components.

# --questions--

## --text--

Which of the following is the correct way to export a React component?

## --answers--

```jsx
export default function Cat() {
  return (
    <div className="card">
      <h2>Mr. Whiskers</h2>
      <img
        src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg"
        alt="Tuxedo cats running on dirt ground."
      />
    </div>
  );
}
```

---

```jsx
exportComponent function Cat() {
  return (
    <div className="card">
      <h2>Mr. Whiskers</h2>
      <img
        src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg"
        alt="Tuxedo cats running on dirt ground."
      />
    </div>
  );
}
```

### --feedback--

Review the middle section where this was discussed.

---

```jsx
e.default function Cat() {
  return (
    <div className="card">
      <h2>Mr. Whiskers</h2>
      <img
        src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg"
        alt="Tuxedo cats running on dirt ground."
      />
    </div>
  );
}
```

### --feedback--

Review the middle section where this was discussed.

---

```jsx
default function Cat() {
  return (
    <div className="card">
      <h2>Mr. Whiskers</h2>
      <img
        src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg"
        alt="Tuxedo cats running on dirt ground."
      />
    </div>
  );
}
```

### --feedback--

Review the middle section where this was discussed.

## --video-solution--

1

## --text--

Where would you typically import a child component like the `Cat` component in a React project?

## --answers--

Inside the `index.html` file.

### --feedback--

Think about where components are commonly composed together in a React project.

---

Inside the `cat-photo-app.css` file.

### --feedback--

Think about where components are commonly composed together in a React project.

---

In a parent component or the root component file (typically `App.jsx`).

---

In the public folder.

### --feedback--

Think about where components are commonly composed together in a React project.

## --video-solution--

3

## --text--

What is the purpose of the `import` statement in the `App` component?

## --answers--

It automatically styles the `App` component.

### --feedback--

Remember that you learned how to work with imports in earlier lessons.

---

It imports the `Cat` component, allowing it to be used within the `App` component.

---

It sets the default state for the `App` component.

### --feedback--

Remember that you learned how to work with imports in earlier lessons.

---

It allows the `App` to run faster.

### --feedback--

Remember that you learned how to work with imports in earlier lessons.

## --video-solution--

2
