---
id: 67329f737126b75bcb949e13
title: What Is an Object in JavaScript, and How Can You Access Properties from an Object?
challengeType: 19
dashedName: what-is-an-object-in-javascript-and-how-can-you-access-properties-from-an-object
---

# --interactive--

In JavaScript, an object is a fundamental data structure that allows you to store and organize related data and functionality. 

You can think of an object as a container that holds various pieces of information, much like a filing cabinet holds different folders and documents. 

These pieces of information are called properties, and they consist of a name (or key) and a value.

```js
const exampleObject = {
  propertyName: value;
}
```

Objects are incredibly versatile and form the backbone of JavaScript. In fact, almost everything in JavaScript is an object or can be treated as one. This includes arrays, functions, and even primitive data types like strings and numbers when used in certain ways. 

This object-centric nature of JavaScript is one of the reasons it's such a flexible and powerful language. Let's look at how you can create an object:

```js
const person = {
  name: "Alice",
  age: 30,
  city: "New York"
};
```

In this example, we've created an object called `person` with three properties: `name`, `age`, and `city`. Each property has a name and a value, separated by a colon.

Now, let's explore how you can access these properties. There are two main ways to access object properties in JavaScript: dot notation and bracket notation.

Dot notation is the most common and straightforward way to access object properties. Here is the basic syntax for dot notation:

```js
objectName.propertyName
```

Here's how you would use dot notation with our `person` object:

:::interactive_editor

```js
const person = {
  name: "Alice",
  age: 30,
  city: "New York"
};

console.log(person.name);  // Alice
console.log(person.age);   // 30
```

:::

Dot notation is concise and easy to read, making it the preferred choice when you know the exact name of the property you want to access and that name is a valid JavaScript identifier (meaning it doesn't start with a number and doesn't contain special characters or spaces).

Bracket notation, on the other hand, allows you to access object properties using a string inside square brackets. Here's how you would use bracket notation:

:::interactive_editor

```js
const person = {
  name: "Alice",
  age: 30,
  city: "New York"
};

console.log(person["name"]); // Alice
console.log(person["age"]); //  30
```

:::

Bracket notation is more flexible than dot notation because it allows you to use property names that aren't valid JavaScript identifiers. For example, if you had a property name with spaces or that starts with a number, you'd need to use bracket notation:

:::interactive_editor

```js
const oddObject = {
  "1stProperty": "Hello",
  "property with spaces": "World"
};

console.log(oddObject["1stProperty"]);  // Hello
console.log(oddObject["property with spaces"]);  // World
```

:::

Another advantage of bracket notation is that it allows you to use variables to access properties dynamically:

:::interactive_editor

```js
const person = {
  name: "Alice",
  age: 30,
  city: "Wonderland"
};

let propertyName = "city";
console.log(person[propertyName]); // Wonderland
```

:::

This flexibility makes bracket notation particularly useful when you don't know the exact property name at the time you're writing the code, or when you're working with property names that come from user input or some other dynamic source.

It's worth noting that objects in JavaScript are incredibly powerful and versatile. They can contain not just simple values like strings and numbers, but also arrays, or other objects.

Understanding objects and how to work with them is crucial in JavaScript because they're used extensively throughout the language and in many JavaScript libraries and frameworks. 

As you continue to learn and work with JavaScript, you'll find that mastering objects opens up a world of possibilities for creating complex and powerful applications.

# --questions--

## --text--

Which notation would you use to access a property of an object if the property name contains spaces?

## --answers--

Dot notation

### --feedback--

Think about which notation allows for more flexibility in property names.

---

Bracket notation

---

Both dot and bracket notation

### --feedback--

Think about which notation allows for more flexibility in property names.

---

Neither, it's not possible to have property names with spaces

### --feedback--

Think about which notation allows for more flexibility in property names.

## --video-solution--

2

## --text--

What's an advantage of using bracket notation over dot notation when accessing object properties?

## --answers--

It's faster to type.

### --feedback--

Remember what we said about using dynamic property names.

---

It allows you to use variables as property names.

---

It's the only way to access nested properties.

### --feedback--

Remember what we said about using dynamic property names.

---

It automatically converts property names to uppercase.

### --feedback--

Remember what we said about using dynamic property names.

## --video-solution--

2

## --text--

Why is it said that most things in JavaScript are objects?

## --answers--

Because everything in JavaScript has properties and methods.

### --feedback--

Recall what we mentioned about the nature of different data types in JavaScript.

---

Because JavaScript was originally designed for object-oriented programming.

### --feedback--

Recall what we mentioned about the nature of different data types in JavaScript.

---

Because objects are the only data type in JavaScript.

### --feedback--

Recall what we mentioned about the nature of different data types in JavaScript.

---

Because even primitive data types can be treated as objects in certain contexts.

## --video-solution--

4
