---
id: 6732b73509f71f24ef05e86e
title: How Do You Work with Accessing Properties from Nested Objects and Arrays in Objects?
challengeType: 19
dashedName: how-do-you-work-with-accessing-properties-from-nested-objects-and-arrays-in-objects
---

# --interactive--

When working with JavaScript, you'll often encounter complex data structures that involve nested objects and arrays within objects. These structures can represent rich, hierarchical data, but they also require a clear understanding of how to access and manipulate the data within them. Let's explore how to navigate these nested structures effectively.

Accessing properties from nested objects involves using the dot notation or bracket notation, much like accessing properties from simple objects. However, you'll need to chain these accessors to drill down into the nested structure. 

For example, let's consider a nested object representing a person with contact information:

```js
const person = {
  name: "Alice",
  age: 30,
  contact: {
    email: "alice@example.com",
    phone: {
      home: "123-456-7890",
      work: "098-765-4321"
    }
  }
};
```

To access `Alice`'s work phone number, you would chain the property accessors like this:

:::interactive_editor

```js
const person = {
  name: "Alice",
  age: 30,
  contact: {
    email: "alice@example.com",
    phone: {
      home: "123-456-7890",
      work: "098-765-4321"
    }
  }
};

console.log(person.contact.phone.work); // "098-765-4321"
```

:::

You can also use bracket notation, which is particularly useful when property names include spaces or special characters, or when you're using variables to access properties:

:::interactive_editor

```js
const person = {
  name: "Alice",
  age: 30,
  contact: {
    email: "alice@example.com",
    phone: {
      home: "123-456-7890",
      work: "098-765-4321"
    }
  }
};

console.log(person['contact']['phone']['work']); // "098-765-4321"
```

:::

Now, let’s take a look at how we can access data where one of the object properties has the value of an array. Here is a modified `person` object that includes an array of addresses:

```js
const person = {
  name: "Alice",
  age: 30,
  addresses: [
    { type: "home", street: "123 Main St", city: "Anytown" },
    { type: "work", street: "456 Market St", city: "Workville" }
  ]
};
```

Here is an example of how to access `Alice`'s work address city:

:::interactive_editor

```js
const person = {
  name: "Alice",
  age: 30,
  addresses: [
    { type: "home", street: "123 Main St", city: "Anytown" },
    { type: "work", street: "456 Market St", city: "Workville" }
  ]
};

console.log(person.addresses[1].city); // "Workville"
```

:::

In this example, `person.addresses` refers to the array of addresses. To access the second address in that array, we use bracket notation and index `1`. Then, we use dot notation to access the `city` from that address object.

Understanding how to access properties in nested objects and arrays is essential when working with complex data structures. In future workshops and labs, you will have the opportunity to practice working with these types of data structures.

# --questions--

## --text--

How would you access the `work` phone number from this object?

```js
let person = {
    contact: {
        phone: {
            home: "123-456-7890",
            work: "098-765-4321"
        }
    }
};
```

## --answers--

`person.work`

### --feedback--

Think about how we need to navigate through each level of the nested object.

---

`person.contact.work`

### --feedback--

Think about how we need to navigate through each level of the nested object.

---

`person.contact.phone.work`

---

`person[contact][phone][work]`

### --feedback--

Think about how we need to navigate through each level of the nested object.

## --video-solution--

3

## --text--

What will be the output of the following code?

```js
let person = {
    name: "Alice",
    details: {
        age: 25,
        hobbies: ["reading", "swimming"]
    }
};

console.log(person.details.hobbies[1]);
```

## --answers--

`reading`

### --feedback--

Consider how to access elements in an array that is nested within an object.

---

`swimming`

---

`undefined`

### --feedback--

Consider how to access elements in an array that is nested within an object.

---

This will throw an error.

### --feedback--

Consider how to access elements in an array that is nested within an object.

## --video-solution--

2

## --text--

In the following code, what will be logged to the console?

```js
let data = {
    results: [
        { name: "Alice", score: 95 },
        { name: "Bob", score: 80 },
        { name: "Charlie", score: 90 }
    ]
};

console.log(data.results[1].name);
```

## --answers--

`Alice`

### --feedback--

Consider the structure of the data object and how we access elements in an array.

---

`Bob`

---

`Charlie`

### --feedback--

Consider the structure of the data object and how we access elements in an array.

---

`undefined`

### --feedback--

Consider the structure of the data object and how we access elements in an array.

## --video-solution--

2
