---
id: 6732b758194c97257d23fc72
title: What Is the Object() Constructor, and When Should You Use It?
challengeType: 19
dashedName: what-is-the-object-constructor-and-when-should-you-use-it
---

# --interactive--

In JavaScript, a constructor is a special type of function used to create and initialize objects. It is invoked with the `new` keyword and can initialize properties and methods on the newly created object.

In this lesson, we will take a look at how to work with the `Object()` constructor. The `Object()` constructor creates a new empty object. Here is an example:

```js
new Object()
```

When you call `new Object()`, it returns a new object that can be used to store values.

The `Object()` constructor can be used with or without the `new` keyword. When called as a function without `new`, it behaves differently depending on the type of value passed to it. Here's an example of using the `Object()` constructor without the `new` keyword:

:::interactive_editor

```js
const num = 42;
const numObj = Object(num); // Creates an object wrapper for the number

console.log(numObj);
console.log(typeof numObj); // "object"
```

:::

As you can see in the second `console.log`, `numObj` is an object. This is happening because we used the `Object()` constructor to turn that input of a number into an object. 

What happens if we try to pass `null` or `undefined` to the `Object()` constructor?

:::interactive_editor

```js
const newObj = new Object(undefined);
console.log(newObj); // {}
```

:::

Well, the result will be an empty object. Another use case for the `Object()` constructor is when you're working with a value of unknown type and you need to ensure it's an object. Let’s take a look at the following example:

:::interactive_editor

```js
function toObject(value) {
  if (value === null || value === undefined) {
    return {};
  }

  if (typeof value === "object") {
    return value;
  }

  return Object(value);
}

console.log(toObject(null));

console.log(toObject(true));

console.log(toObject([1, 2, 3]));
```

:::

In this example, we have a function called `toObject`. The second condition will check if the value is a type of object and will return the value if the condition is `true`. This condition will check for objects as well as arrays since arrays are special types of objects.

If neither of the conditions is true, the function returns `Object(value)`, which converts the input into an object. This works for values like numbers, strings, and booleans

Most of the time you will not be using the `Object()` constructor to create new objects because you will be using object literal syntax instead (e.g., `const objectLiteral = { name: "Beau" }`). But it is still good to understand the basics of working with the Object constructor.

# --questions--

## --text--

What will be the output of the following code?

```js
let obj = Object(42);
console.log(typeof obj);
```

## --answers--

`"number"`

### --feedback--

Remember that the `Object()` constructor creates an object wrapper for primitive values.

---

`"object"`

---

`42`

### --feedback--

Remember that the `Object()` constructor creates an object wrapper for primitive values.

---

This will throw an error.

### --feedback--

Remember that the `Object()` constructor creates an object wrapper for primitive values.

## --video-solution--

2

## --text--

What's the difference between `new Object()` and `{}`?

## --answers--

`new Object()` creates an empty object, while `{}` does not.

### --feedback--

Consider the functionality and the common usage of both methods in creating objects.

---

`{}` creates an empty object, while `new Object()` does not.

### --feedback--

Consider the functionality and the common usage of both methods in creating objects.

---

There is no difference, they both create an empty object.

---

`new Object()` is faster than `{}`.

### --feedback--

Consider the functionality and the common usage of both methods in creating objects.

## --video-solution--

3

## --text--

When might you use the `Object()` constructor instead of object literal notation?

## --answers--

When you need better performance.

### --feedback--

Think about the special capabilities of the `Object()` constructor that we discussed in the lesson.

---

When you want to create an object wrapper for a primitive value.

---

When you're working with JSON data.

### --feedback--

Think about the special capabilities of the `Object()` constructor that we discussed in the lesson.

---

When you're creating nested objects.

### --feedback--

Think about the special capabilities of the `Object()` constructor that we discussed in the lesson.

## --video-solution--

2
