---
id: 672d49959621885e9d3e672c
title: How Do let and const Work Differently When It Comes to Variable Declaration, Assignment, and Reassignment?
challengeType: 19
dashedName: how-do-let-and-const-work
---

# --interactive--

When working with JavaScript, you'll often declare variables to store data that you plan to use throughout your program.

In modern JavaScript, `let` and `const` are the preferred ways to declare variables, but they differ in how they handle value assignment and reassignment.

In this lesson, we'll explore how `let` and `const` differ in variable declaration, assignment, and reassignment.

The `let` keyword allows you to declare variables that can be updated or reassigned later. You can think of `let` as a flexible container – once you've stored a value in it, you can change that value as needed throughout your program.

Here's an example of declaring and assigning a variable with `let`:

```js
let score = 10;
```

In this case, the variable `score` is declared and assigned the value `10`. If you want to update the value later, you can easily do that:

:::interactive_editor

```js
let score = 10;
console.log(score); // 10
score = 20;
console.log(score); // 20
```

:::

Now, `score` holds the value `20`. This makes `let` particularly useful when you know the value of a variable will change as your program runs.

On the other hand, `const` is used to declare variables that are constant. Once you assign a value to a variable declared with `const`, you cannot reassign it.

This makes `const` ideal for values that you don't want to change accidentally during the execution of your program.

Here's an example of declaring and assigning a variable with `const`:

:::interactive_editor

```js
const maxScore = 100;
console.log(maxScore); // 100
```

:::

Once `maxScore` is assigned the value `100`, it cannot be changed:

```js
maxScore = 200; // This will result in an error
```

Trying to reassign a value to a `const` variable will throw an error in your JavaScript console, as `const` variables are immutable once they are assigned.

You can declare a `let` variable without immediately assigning it a value, and you can assign it a value later:

:::interactive_editor

```js
let age;
console.log(age); // undefined
age = 25;
console.log(age); // 25
```

:::

Variables declared with `const` must be assigned a value at the time of declaration. If you try to declare a `const` variable without assigning it a value, you will get an error:

```js
const age; // Error: Missing initializer in const declaration
```

You should use `let` when you need to declare variables that will be reassigned later. For example, tracking a changing score or updating a value over time in your program.

Use `const` when you want to declare variables that should remain constant, like configuration values or settings that shouldn't be changed accidentally.

You can also use the `var` keyword, but it's not as recommended anymore. The `var` is kind of like `let`, except it has a wider scope, which is more likely to cause problems in your program.

# --questions--

## --text--

What happens if you try to reassign a value to a variable declared with `const`?

## --answers--

The value will change without issue.

### --feedback--

Think about what `const` stands for.

---

The original value will be updated, but a warning will be issued.

### --feedback--

Think about what `const` stands for.

---

An error will be thrown because `const` variables cannot be reassigned.

---

The new value will be ignored, and the original value will stay the same.

### --feedback--

Think about what `const` stands for.

## --video-solution--

3

## --text--

Which of the following is the correct way to assign the number `100` to a constant named `maxScore`?

## --answers--

```js
const maxScore === 100;
```

### --feedback--

Refer to the end of the lesson where this was discussed.

---

```js
const maxScore = 100;
```

---

```js
const maxScore <= 100;
```

### --feedback--

Refer to the end of the lesson where this was discussed.

---

```js
const maxScore == 100;
```

### --feedback--

Refer to the end of the lesson where this was discussed.

## --video-solution--

2

## --text--

Can you declare a `const` variable without assigning it a value?

## --answers--

Yes, but you must assign a value later.

### --feedback--

Think about the immutability of `const`.

---

No, `const` variables must be initialized at the time of declaration.

---

Yes, but you can only assign a number as the initial value.

### --feedback--

Think about the immutability of `const`.

---

No, `const` variables must be declared and reassigned in the same line.

### --feedback--

Think about the immutability of `const`.

## --video-solution--

2
