---
id: 672d49c4e899345f5b33c24c
title: What Is console.log Used For, and How Does It Work?
challengeType: 19
dashedName: what-is-console-log
---

# --interactive--

The prior lessons introduced you to `console.log()` but this lesson will dive deeper into its purpose and usage.

In JavaScript, `console.log()` is a simple yet powerful tool used to display messages or output information to the browser's console. It's mostly used by developers to debug and inspect code while working on their programs.

You can use `console.log()` to log text or variables to the console and ensure your code is running correctly.

To use `console.log()`, you call the method with the value or message you want to output inside the parentheses. Here are some examples:

:::interactive_editor

```js
console.log("Hello, world!");

let num = 5;
console.log(num); // 5
```

:::

The first example prints `Hello, world!` in the browser's console, while the second example prints the value `5`.

Here is another example of working with `console.log()`:

:::interactive_editor

```js
let name = "Alice";
console.log("Hello, " + name + "!"); // Hello, Alice!
```

:::

You can also pass in multiple values to `console.log()` separated by commas. For example:

:::interactive_editor

```js
let name = "Alice";
let age = 25;
console.log("Name:", name, "Age:", age); // Name: Alice Age: 25
```

:::

This is helpful for logging multiple pieces of information at once.

The `console.log()` method helps you monitor your code as it runs, making it easier to spot mistakes and understand how your program behaves.

# --questions--

## --text--

What does the `console.log()` method do in JavaScript?

## --answers--

It audits your code for errors and displays the results in the browser console.

### --feedback--

Think about where you can see the results of the `console.log()` method.

---

It is used to log data and display the output in the browser console.

---

It stores values in a database as well as the browser console.

### --feedback--

Think about where you can see the results of the `console.log()` method.

---

It changes the HTML content on the page and shows the changes in the browser console.

### --feedback--

Think about where you can see the results of the `console.log()` method.

## --video-solution--

2

## --text--

What will be logged to the console?

```js
const age = 10;
console.log(age);
```

## --answers--

`10`

---

`"10"`

### --feedback--

Remember that `console.log()` will log the value of that variable.

---

`age`

### --feedback--

Remember that `console.log()` will log the value of that variable.

---

`"age"`

### --feedback--

Remember that `console.log()` will log the value of that variable.

## --video-solution--

1

## --text--

Why is `console.log()` helpful when building out web applications?

## --answers--

It is commonly used to check the performance for an application and see the results in the console.

### --feedback--

Review the beginning of the lesson where this was discussed.

---

It is commonly used by developers for debugging and inspecting values or expressions in their code during development.

---

It is commonly used to check for linting errors in your code and display those errors in the console.

### --feedback--

Review the beginning of the lesson where this was discussed.

---

It is commonly used to ensure that your JavaScript code is adhering to best practices.

### --feedback--

Review the beginning of the lesson where this was discussed.

## --video-solution--

2
