---
id: 6839b3295323f563efc68f5c
title: How Do Augmented Assignments Work?
challengeType: 19
dashedName: how-do-augmented-assignments-work
---

# --description--

Augmented assignment combines a binary operation with an assignment in one step. It takes a variable, applies an operation to it with another value, and stores the result back into the same variable.

If you're familiar with a language like JavaScript, you've probably heard of the addition assignment operator (`+=`) or subtraction assignment (`-=`), and others. Those exist in Python, too. The only difference is that they're referred to as **augmented assignments**.

The basic syntax of an augmented assignment looks like this:

```python
variable <operator>= value
```

Which is a more efficient way of doing this:

```python
variable = variable <operator> value
```

For example, here's an example of using augmented assignment to add `5` to an existing variable:

```python
my_var = 10
my_var += 5

print(my_var) # 15
```

And here is the same thing, but without augmented assignment:

```python
my_var = 10
my_var = my_var + 5

print(my_var) # 15
```

The advantage of augmented assignment is that it provides a concise and readable way to update a variable value without repeating the variable name. In turn, this reduces redundancy and potential errors that might arise from a typo or something similar.

Every operator can use an augmented assignment. We've looked at the addition assignment operator (`+=`), so let's look at others.

- The subtraction assignment operator (`-=`) subtracts the right operand from the left variable and stores the difference in the left variable:

```python
count = 14
count -= 3

print(count) # 11
```

- The multiplication assignment operator (`*=`) multiplies the left variable by the right operand and stores the product back in the left variable:
    

```python
product = 65
product *= 7

print(product) # 455
```

- The division assignment operator (`/=`) divides the left variable by the right and stores the result back in the left variable:
    

```python
price = 100
price /= 4

print(price) # 25.0
```

- The floor division operator (`//=`) floor‑divides the left variable by the right and stores the result back in the left variable:
    

```python
total_pages = 23
total_pages //= 5

print(total_pages) # 4
```

- The modulus assignment operator (`%=`) computes the remainder of the left variable divided by the right and stores it back in the left variable:
    

```python
bits = 35
bits %= 2

print(bits) # 1
```

- The exponentiation assignment operator (`**=`) raises the left variable to the power of the right and stores the result back in the left variable:
    

```python
power = 2
power **= 3

print(power) # 8
```

You can use some augmented assignment operators with strings, too. For example, the addition assignment operator makes it easy to concatenate strings:

```python
greet = 'Hello'
greet += ' World'

print(greet) # Hello World
```

And the multiplication assignment operator can be used to repeat a string:

```python
greet = 'Hello'
greet *= 3

print(greet) # HelloHelloHello
```

Other augmented assignments throw a `TypeError` when you use them with strings:

```python
greet = 'Hello'
greet -= ' World'

print(greet) # TypeError: unsupported operand type(s) for -=: 'str' and 'str'


greet = 'Hello'
greet /= 'World'

print(greet) # TypeError: unsupported operand type(s) for /=: 'str' and 'str' 
```

If you're wondering if increment and decrement operators (`++` and  `--`) work in Python, they don't. That's because Python deliberately avoids C-style increment and decrement shortcuts in order to keep the language clear and explicit.

Instead of `x++`, you can simply write `x += 1`, which makes it obvious that you're incrementing the value of `x` by `1`.

Writing `++x` in Python just applies the unary plus twice, and increment anything:

```python
my_var = 5

print(+my_var)   # 5
print(++my_var)  # 5
print(+++my_var) # 5

my_var += 1

print(my_var) # 6
```

# --questions--

## --text--

What is the main advantage of using augmented assignment operators?

## --answers--

They automatically convert data types.

### --feedback--

Think about how augmented assignments help avoid redundancy and reduce typing mistakes.

---

They prevent all possible syntax errors.

### --feedback--

Think about how augmented assignments help avoid redundancy and reduce typing mistakes.

---

They provide a concise way to update variables without repeating the variable name.

---

They make mathematical operations faster.

### --feedback--

Think about how augmented assignments help avoid redundancy and reduce typing mistakes.

## --video-solution--

3

## --text--

What happens when you use the increment (`++`) and decrement (`--`) operators in Python?

## --answers--

They work exactly like in C/C++.

### --feedback--

Think about how Python avoids C-style increment and decrement operators.

---

They cause a syntax error and crash the program.

### --feedback--

Think about how Python avoids C-style increment and decrement operators.

---

They are interpreted as double unary operators with no actual increment/decrement.

---

They only work in Python 2 but were removed in Python 3.

### --feedback--

Think about how Python avoids C-style increment and decrement operators.

## --video-solution--

3

## --text--

Which augmented assignment operator raises a variable to a power and stores the result back to that variable?

## --answers--

`^=`

### --feedback--

Think about the operator that uses the same symbol as exponentiation operator.

---

`**=`

---

`*=`

### --feedback--

Think about the operator that uses the same symbol as exponentiation operator.

---

`^^=`

### --feedback--

Think about the operator that uses the same symbol as exponentiation operator.

## --video-solution--

2
