---
id: 67d311d256c58ef01e0d62ec
title: What Are React Frameworks, and Why Are They Commonly Used in the Industry?
challengeType: 19
dashedName: what-are-react-frameworks-and-why-are-they-commonly-used-in-the-industry
---

# --description--

Up until this point, you have been using React to build out user interfaces. If you needed additional features like routing, then you had to import a third party library like React Router to be able to switch between the different views.

But what happens when you need to build out a full stack web application? Well you could use React for the frontend and use Node and Express for the backend logic if you just want to stick with JavaScript. Or you could use other languages like Go, Python, or Java for your backend.

While all of these are viable options, there are times where you might want to use a React framework instead. React frameworks provide features like routing, image optimizations, data fetching, authentication and more. This means that you might not need to set up separate frontend and backend applications for certain use cases.

Let's take a closer look at Next.js which is a popular React framework. One of the main features for Next.js is the file-system based router. This routing system includes support for dynamic routes, parallel routes, route handlers, redirects, internalization and more.

Here is an example of creating a custom request handler:

```js
export async function GET() {
  const res = await fetch("https://example-api.com");
  const data = await res.json();

  return Response.json({ data });
}
```

You can define route handlers like GET or POST requests in a file called `route.js` inside the `app/api` directory.

Another feature of Next.js are the automatic image and font optimizations.

Here is an example of working with the `Image` component inside a `page.js` file:

```jsx
import Image from "next/image";

export default function Page() {
  return (
    <Image src="link-to-image-goes-here" alt="descriptive-title-goes-here" />
  );
}
```

The `Image` component extends the native HTML `img` element and allows for faster page loads and size optimizations. This means that images will only load when they enter the viewport and the `Image` component will automatically serve correctly sized images for each device.

While those are just a few features of Next.js, there are many more features that you can use to build robust full stack web applications. There are also other React frameworks like Remix that will provide the same ability to build out modern full stack web applications.

Even though the JavaScript library and framework landscape is constantly changing, it is important to be aware of the available options to you and learn about each framework's pros and cons.

# --questions--

## --text--

Which of the following is an example of a React framework?

## --answers--

Spring

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Laravel

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Next.js

---

Django

### --feedback--

Refer to the beginning of the lesson where this was discussed.

## --video-solution--

3

## --text--

Which of the following is NOT a feature of a React framework?

## --answers--

Automatic CSS cleanup.

---

Routing.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Image optimization.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Data fetching.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

## --video-solution--

1

## --text--

What are some benefits to working with the Next.js `Image` component?

## --answers--

It automatically increases the size of all images to improve quality.

### --feedback--

Refer to the end of the lesson where this was discussed.

---

It results in faster page loads and size optimizations.

---

It guarantees zero performance impact when loading images.

### --feedback--

Refer to the end of the lesson where this was discussed.

---

It has zero support for lazy loading for images.

### --feedback--

Refer to the end of the lesson where this was discussed.

## --video-solution--

2
