---
id: 672b952d3a5c603908841971
title: Why Are Default Link Styles Important for Usability on the Web?
challengeType: 19
dashedName: why-are-default-link-styles-important-for-usability-on-the-web
---

# --interactive--

Default link styles play a crucial role in enhancing usability and accessibility on the web.

These styles, typically blue for unvisited links and purple for visited links, have become a standard that users have come to expect and rely on when navigating websites.

The primary purpose of default link styles is to provide clear visual cues that help users distinguish between interactive and non-interactive elements on a webpage.

This distinction is fundamental to creating an intuitive and user-friendly browsing experience.

Let's consider the basic default styles for links:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<a href="/">Example link</a>
```

```css
a:link {
  color: blue;
  text-decoration: underline;
}

a:visited {
  color: purple;
}
```

:::

These styles serve several important functions.

Firstly, the blue color for unvisited links stands out against most background colors and text, making links easily identifiable. This contrast is crucial for users to quickly scan a page and find navigational elements or important information.

The underline further emphasizes that the text is clickable, providing an additional visual cue. This is particularly helpful for users who may be colorblind or have difficulty distinguishing colors.

The change in color for visited links (typically to purple) helps users keep track of where they've been. This feature is invaluable for navigating large websites or conducting research, as it prevents users from inadvertently revisiting the same pages.

Consider this HTML example:

:::interactive_editor

```html
<p>Learn more about <a href="https://www.example.com/cats">cats</a> and <a href="https://www.example.com/dogs">dogs</a>.</p>
```

:::

Without any custom CSS, most browsers will render these links in blue with an underline. After clicking on one of the links, its color will change to purple, providing immediate feedback to the user about their browsing history.

While it's common for designers to modify these default styles to match a website's aesthetic, it's crucial to maintain the core principles behind them.

If you choose to change the default styles, ensure that links are still clearly distinguishable from regular text, there's a visible difference between visited and unvisited links, and the chosen colors provide sufficient contrast with the background.

For example, you might use a custom style like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<a href="/">Example link</a>
```

```css
a:link {
  color: blue;
  text-decoration: none;
  border-bottom: 1px solid blue;
}

a:visited {
  color: purple;
  border-bottom: 1px solid purple;
}
```

:::

This maintains the blue and purple color scheme while replacing the underline with a bottom border for a more modern look.

It's also important to consider the different states of links. In addition to the default and visited states, links typically have hover and active states:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">

<a href="/">Example link</a>
```

```css
a:hover {
  color: red;
}

a:active {
  color: darkorange;
}
```

:::

These states provide immediate feedback to users as they interact with links, enhancing the overall usability of the site.

In conclusion, while it's possible to customize link styles, the principles behind the default styles should be maintained.

They play a crucial role in creating a usable and accessible web experience, helping users navigate and interact with content effectively.

Always prioritize clarity and user experience when designing link styles for your websites.

# --questions--

## --text--

Why is it important to have a distinct color for visited links?

## --answers--

It makes the website more colorful.

### --feedback--

Think about how this feature affects a user's navigation through a website.

---

It helps users keep track of pages they've already visited.

---

Visited links are more important than unvisited links.

### --feedback--

Think about how this feature affects a user's navigation through a website.

---

It's a legal requirement for websites.

### --feedback--

Think about how this feature affects a user's navigation through a website.

## --video-solution--

2

## --text--

Which of the following is NOT typically a default style for links in most browsers?

## --answers--

Blue color for unvisited links.

### --feedback--

Consider the most common visual characteristics of links you see on websites.

---

Underline for all links.

### --feedback--

Consider the most common visual characteristics of links you see on websites.

---

Purple color for visited links.

### --feedback--

Consider the most common visual characteristics of links you see on websites.

---

Bold font weight for all links.

## --video-solution--

4

## --text--

When customizing link styles, what is an important principle to maintain?

## --answers--

All links must be blue.

### --feedback--

Think about the main purpose of link styles in terms of usability.

---

Links should always be underlined.

### --feedback--

Think about the main purpose of link styles in terms of usability.

---

Links should be clearly distinguishable from regular text.

---

Visited and unvisited links must have the same style.

### --feedback--

Think about the main purpose of link styles in terms of usability.

## --video-solution--

3
