---
id: 67335f45489c5a11b71d0ed5
title: What Is Hoisting?
challengeType: 19
dashedName: what-is-hoisting
---

# --interactive--

Hoisting is a behavior in JavaScript that often confuses beginners, but understanding it can help you avoid subtle bugs in your code. In simple terms hoisting is JavaScript's default behavior of moving declarations to the top of their respective scopes during the compilation phase before the code is executed.

To understand hoisting, it's important to know that JavaScript runs in two phases: the compilation phase and the execution phase. During the compilation phase, the JavaScript engine goes through your code and sets up memory space for variables and functions. This is where hoisting comes into play.

Let's start with variables hoisting, when you declare a variable using the `var` keyword, JavaScript hoists the declaration to the top of its scope. However it's crucial to note that only the declaration is hoisted, not the initialization. This means you can use a variable in your code before you have declared it, but its value will be `undefined` until you actually assign a value to it.

:::interactive_editor

```js
console.log(x); // undefined
var x = 5;
console.log(x); // 5
```

:::

In this code even though we use `x` before declaring it we don't get an error, instead we get `undefined`. This is because JavaScript hoists the declaration `var x` to the top of its scope but not the initialization `x = 5`. It's as if the code were rewritten like this:

:::interactive_editor

```js
var x;
console.log(x); // undefined
x = 5;
console.log(x); // 5
```

:::

Function hoisting works a bit differently. When you declare a function using the `function` declaration syntax both the function name and the function body are hoisted. This means you can call a function before you've declared it in your code. Here's an example of function hoisting:

:::interactive_editor

```js
sayHello(); // "Hello, World!"

function sayHello(){
  console.log("Hello, World!");
}
```

:::

In this case, we can call `sayHello()` before its declaration because the entire function is hoisted to the top of its scope.

It's important to note that hoisting works differently with `let` and `const` declarations introduced in ES6.

```js
console.log(y); // Throws a ReferenceError
let y = 10;
```

These declarations are hoisted but they are not initialized and you can't access them before the actual declaration in your code. This is often referred to as the temporal dead zone.

Understanding hoisting can help you write cleaner, more predictable code. However, relying on hoisting can make your code harder to read and maintain. As a best practice, it's recommended to declare your variables at the top of their scope and your functions before you use them regardless of hoisting. This make your code's behavior more explicit and easier for others including your future self to understand.

# --questions--

## --text--

What happens when a variable declared with `var` is hoisted?

## --answers--

Both the declaration and initialization are moved to the top.

### --feedback--

Think about what value a hoisted variable has before it's explicitly assigned a value.

---

Only the declaration is moved to the top.

---

The variable is not hoisted at all.

### --feedback--

Think about what value a hoisted variable has before it's explicitly assigned a value.

---

The variable is deleted from the code.

### --feedback--

Think about what value a hoisted variable has before it's explicitly assigned a value.

## --video-solution--

2

## --text--

How does function hoisting differ from variable hoisting?

## --answers--

Functions are not hoisted.

### --feedback--

Consider whether you can call a function before its declaration in the code.

---

Only the function name is hoisted.

### --feedback--

Consider whether you can call a function before its declaration in the code.

---

Both the function name and body are hoisted.

---

Function hoisting only works with arrow functions.

### --feedback--

Consider whether you can call a function before its declaration in the code.

## --video-solution--

3

## --text--

What is the result of trying to access a variable declared with `let` before its declaration in the code?

## --answers--

It returns `undefined`.

### --feedback--

Think about the concept of the "temporal dead zone" mentioned in the lesson.

---

It throws a `ReferenceError`.

---

It returns `null`.

### --feedback--

Think about the concept of the "temporal dead zone" mentioned in the lesson.

---

It works without any issues

### --feedback--

Think about the concept of the "temporal dead zone" mentioned in the lesson.

## --video-solution--

2
