---
id: 673407be6af21d6766ed4b96
title: How Does the Fetch API Work with Common HTTP Methods and res.json()?
challengeType: 19
dashedName: how-does-the-fetch-api-work-with-common-http-methods-and-res-json
---

# --description--

In the previous lesson, we saw what the Fetch API is and how to use it. In this lesson, we will discuss about the `GET`, `POST`, `PUT` and `DELETE` HTTP methods of Fetch API.

Let's start with the most common HTTP method which is the `GET` method. This is used to retrieve data from a server. When you use `fetch()` without specifying a method, it defaults to `GET`.

```js
fetch('https://api.example.com/data')
```

In this code, we're making a `GET` request to `https://api.example.com/data`. Now, please note that you cannot use this data directly, you have to convert the response to a JSON format. Only then you can use it anywhere you want in your project. Here’s an example of how to do it:

```js
fetch('https://api.example.com/data')
  .then(response => response.json())
  .then(data => console.log(data))
```

In this code, the response coming from the Fetch API is a promise, and we are using a `.then` handler to convert the response to a JSON format. In a prior lesson, you learned that a `Promise` is an object that represents the eventual completion (or failure) of an asynchronous process and its value.

The value of a promise is not known when the promise is created. It’s only known when the asynchronous process is completed. When we chain the two `.then` handlers to the fetch call, this is something called promise chaining which will be taught in the next lesson.

So far we have been retrieving resources from a server. But, did you know that we can also send data to the server? The `POST` method is used to send data to a server to create a resource. Here’s an example of a `POST` method which is used to create data into the server: 

```js
fetch('https://api.example.com/users', {
  method: 'POST',
  headers: {
    'Content-Type': 'application/json',
  },
  body: JSON.stringify({
    name: 'John Doe',
    email: 'john@example.com'
  })
})
```

In this example, we're sending a `POST` request to create a new user. We specify the method as `POST`, set the appropriate headers, and include a `body` with the data we want to send. The body needs to be a string, so we use `JSON.stringify()` to convert our object to a JSON string.

The `PUT` method is used to update existing resources of a server. Here’s an example: 

```js
fetch('https://api.example.com/users/45', {
  method: 'PUT',
  headers: {
    'Content-Type': 'application/json',
  },
  body: JSON.stringify({
    name: 'John Smith',
    email: 'john@example.com'
  })
})
```

In this example, look carefully at the URL, you can see a `45` at the end. This is typically used as a unique ID to identify the data we are trying to update. We used the `PUT` method on the code and also specified the data as the `body` which will be used to update the identified data. 

The `DELETE` method is used to delete a resource from the server. Here’s an example:

```js
fetch('https://api.example.com/users/45', {
  method: 'DELETE',
})
```

In this code, we are including the `DELETE` method and an ID at the end of the url to identify the data which needs to be deleted. 

# --questions--

## --text--

What is the default HTTP method used by `fetch()` if not specified?

## --answers--

`POST`

### --feedback--

Think about the most common operation when retrieving data from a server.

---

`GET`

---

`PUT`

### --feedback--

Think about the most common operation when retrieving data from a server.

---

`DELETE`

### --feedback--

Think about the most common operation when retrieving data from a server.

## --video-solution--

2

## --text--

When sending data with a `POST` request using `fetch()`, what do you need to do with the data before including it in the body?

## --answers--

Encrypt it.

### --feedback--

Consider how data needs to be formatted when sending it in a request body.

---

Compress it.

### --feedback--

Consider how data needs to be formatted when sending it in a request body.

---

Convert it to a JSON string.

---

Base64 encode it.

### --feedback--

Consider how data needs to be formatted when sending it in a request body.

## --video-solution--

3

## --text--

What does the `response.json()` method do?

## --answers--

Sends JSON data to the server.

### --feedback--

Think about how the data from the server needs to be processed to be usable in JavaScript.

---

Creates a new JSON object.

### --feedback--

Think about how the data from the server needs to be processed to be usable in JavaScript.

---

Parses the response body as JSON.

---

Validates if the response is in JSON format.

### --feedback--

Think about how the data from the server needs to be processed to be usable in JavaScript.

## --video-solution--

3
