---
id: 673282bea35dbf129efb63d6
title: What Are Switch Statements and How Do They Differ from If/Else Chains?
challengeType: 19
dashedName: what-are-switch-statements-and-how-do-they-differ-from-if-else-chains
---

# --interactive--

`switch` statements and `if/else if/else` chains are both control flow structures in programming that allow us to execute different code blocks based on certain conditions. However, they have distinct characteristics and use cases.

A `switch` statement evaluates an expression and matches its value against a series of `case` clauses. When a match is found, the code block associated with that `case` is executed. Here's a basic structure of a `switch` statement:

```js
switch (expression) {
  case value1:
    // code to be executed if expression === value1
    break;
  case value2:
    // code to be executed if expression === value2
    break;
  default:
    // code to be executed if expression doesn't match any case
}
```

The `break` statement at the end of each `case` is crucial. It tells the program to exit the switch block once a matching `case` has been executed. Without it, the program would continue executing subsequent cases, a behavior known as "fall-through".

`switch` statements are typically used when you're comparing a single variable against multiple possible values. They're especially useful when you have many potential conditions to check against a single variable. Here is an example using a `switch` statement for the days of the week:

:::interactive_editor

```js
let dayOfWeek = 3; 

switch (dayOfWeek) {
    case 1:
        console.log("It's Monday! Time to start the week strong.");
        break;
    case 2:
        console.log("It's Tuesday! Keep the momentum going.");
        break;
    case 3:
        console.log("It's Wednesday! We're halfway there.");
        break;
    case 4:
        console.log("It's Thursday! Almost the weekend.");
        break;
    case 5:
        console.log("It's Friday! The weekend is near.");
        break;
    case 6:
        console.log("It's Saturday! Enjoy your weekend.");
        break;
    case 7:
        console.log("It's Sunday! Rest and recharge.");
        break;
    default:
        console.log("Invalid day! Please enter a number between 1 and 7.");
}
```

:::

`switch` statements can be more readable and concise when dealing with many possible values for a single variable. 

`if/else if` statements on the other hand are more flexible. They can evaluate complex conditions and different variables in each clause. This makes them suitable for a wider range of scenarios. Here is an example of when you might use an `if/else` statement over a `switch` statement:

:::interactive_editor

```js
let creditScore = 720; 
let annualIncome = 60000; 
let loanAmount = 200000; 

let eligibilityStatus;

if (creditScore >= 750 && annualIncome >= 80000) {
    eligibilityStatus = "Eligible for premium loan rates.";
} else if (creditScore >= 700 && annualIncome >= 50000) {
    eligibilityStatus = "Eligible for standard loan rates.";
} else if (creditScore >= 650 && annualIncome >= 40000) {
    eligibilityStatus = "Eligible for subprime loan rates.";
} else if (creditScore < 650) {
    eligibilityStatus = "Not eligible due to low credit score.";
} else {
    eligibilityStatus = "Not eligible due to insufficient income.";
}

console.log(eligibilityStatus);
```

:::

In this example, we have a person’s annual income and credit score and checking what types of loan they would qualify for. Since we are dealing with more complex logical evaluations and multiple variables, it is better to use an `if/else` statement here versus a `switch` statement.

It's worth noting that `switch` statements in JavaScript use strict comparison (`===`), which means they don't perform type coercion. This can be an advantage in terms of predictability and avoiding subtle bugs.

In summary, while both `switch` statements and `if/else if` chains allow for multiple-branch logic in your code, they have different strengths. `switch` statements excel at handling multiple possible values for a single variable, while `if/else if` chains offer more flexibility for complex conditions. The choice between them often comes down to the specific requirements of your code and personal or team coding style preferences.

# --questions--

## --text--

What happens if you omit the `break` statement in a `switch` case?

## --answers--

The `switch` statement will throw an error.

### --feedback--

Think about the concept of "fall-through" in `switch` statements.

---

The program will exit the `switch` block immediately.

### --feedback--

Think about the concept of "fall-through" in `switch` statements.

---

The code will continue to the next case, regardless of whether it matches.

---

Nothing, `break` is optional in `switch` statements.

### --feedback--

Think about the concept of "fall-through" in `switch` statements.

## --video-solution--

3

## --text--

Which of the following is a key advantage of using a `switch` statement over an `if`/`else` chain?

## --answers--

`switch` statements can handle more complex conditions.

### --feedback--

Consider the typical use case for `switch` statements and what they're designed to handle efficiently.

---

`switch` statements can compare multiple variables.

### --feedback--

Consider the typical use case for `switch` statements and what they're designed to handle efficiently.

---

`switch` statements are typically more concise for comparing a single variable against many values.

---

`switch` statements always perform faster than `if`/`else` chains.

### --feedback--

Consider the typical use case for `switch` statements and what they're designed to handle efficiently.

## --video-solution--

3

## --text--

In JavaScript, what type of comparison does a `switch` statement use?

## --answers--

Loose equality (`==`).

### --feedback--

Think about whether `switch` statements in JavaScript perform type coercion during comparisons.

---

Strict equality (`===`).

---

Greater than or equal to (`>=`).

### --feedback--

Think about whether `switch` statements in JavaScript perform type coercion during comparisons.

---

Less than or equal to (`<=`).

### --feedback--

Think about whether `switch` statements in JavaScript perform type coercion during comparisons.

## --video-solution--

2
