---
id: 6733d3ab69e94b7df7ee91b0
title: How Does the Submit Event Work with Forms?
challengeType: 19
dashedName: how-does-the-submit-event-work-with-forms
---

# --description--

Let's learn about how the `submit` event works with HTML forms. First, we need to understand how to submit a form. There are three ways a form can be submitted.

The first is when the user clicks a button in the form which has the `type` attribute set to `submit`.

The second is when the user presses the Enter key on any editable input field in the form.

The third is through a JavaScript call to the `requestSubmit()` or `submit()` methods of the form element.

But what happens when a form is submitted? There's a few things that happen, and the behavior of the form depends on its attributes.

The first attribute that we need to look at is the `action` attribute. The `action` attribute should contain either a URL or a relative path for the current domain. This value determines where the form attempts to send data. If you do not set an `action` attribute, the form will send data to the current page's URL. Here is an example of a form with an `action` attribute set to a specific URL:

```html
<form action="https://freecodecamp.org">
  <input type="number" id="input" placeholder="Enter a number" name="number" />
  <button type="submit">Submit</button>
</form>
```

When this form is submitted, it will send data to freeCodeCamp's homepage, which probably won't do anything.

Here's another form, which submits to a relative path:

```html
<form action="/data">
  <input type="number" id="input" placeholder="Enter a number" name="number" />
  <button type="submit">Submit</button>
</form>
```

This one submits to the `/data` path on the current domain. In our case, it would submit to `http://127.0.0.1:5500/data`.

The second attribute to control how a submission behaves is the `method` attribute. This attribute accepts a standard HTTP method, such as `GET` or `POST`, and uses that method when making the request to the `action` URL.

HTTP stands for Hypertext Transfer Protocol and it is used to transfer data over the web.

HTTP methods are used to define the actions that can be performed on resources, such as `GET`, `POST`, `PUT`, `DELETE`, and so on. You will learn more about these methods in future lessons.

When a method is not set, the form will default to a `GET` request. A `GET` request is used to retrieve data from a specified resource without making any changes to it, and the parameters are typically appended to the URL in the form of a query string.

The data in the form will be URL encoded as `name=value` pairs and appended to the `action` URL as query parameters. For instance, by submitting the form from our previous example with the value of `3342` for the `input` field, the form would try to `GET` the URL `http://127.0.0.1:5500/data?number=3342`.

This is great for something like a search form, where your user is querying data. But if you want your user to submit new data, such as in a registration form, the idiomatic method to use would be the `POST` method. The `POST` method is used to send data to the server to create or update a resource.

Let's set the `method` attribute to the value of `POST`:

```xml
<form action="/data" method="POST">
  <input type="number" id="input" placeholder="Enter a number" name="number" />
  <button type="submit">Submit</button>
</form>
```

When you send a `POST` request, a body can be included which contains the data for your request. So unlike a `GET`, the data are not appended to the URL, and our form sends the `POST` request to `http://127.0.0.1:5500/data`. The data, instead, can be found in the body of the request, still as URL-encoded form data.

URL-encoded form data is when form data is converted into a string of key-value pairs, like `name=John+Doe&email=john%40example.com`, where special characters are replaced with encoded versions to safely send the data over the web. You will learn more about this in future lessons.

But maybe you don't want to send the data as a URL-encoded form payload?

The `form` element accepts an `enctype` attribute, which represents the encoding type to use for the data.

This attribute only accepts three values: `application/x-www-form-urlencoded` (which is the default, sending the data as a URL-encoded form body), `text/plain` (which sends the data in plaintext form, in `name=value` pairs separated by new lines), or `multipart/form-data`, which is specifically for handling forms with a file upload.

In this lesson, you've learned the basics of form submissions. In future lessons, we'll dive deeper into working with forms and how they interact with the server.

# --questions--

## --text--

Which of the following is NOT a way to submit an HTML form?

## --answers--

Clicking a button with `type="submit"`.

### --feedback--

The lesson mentions three specific ways to submit a form.

---

Pressing Enter on an editable input field.

### --feedback--

The lesson mentions three specific ways to submit a form.

---

Calling the form's `requestSubmit()` method.

### --feedback--

The lesson mentions three specific ways to submit a form.

---

Double-clicking anywhere within the form.

## --video-solution--

4

## --text--

What happens when a form's `action` attribute is not set?

## --answers--

The form submission is prevented.

### --feedback--

The lesson explains the default behavior when the `action` attribute is missing.

---

The form data is sent to the current page's URL.

---

An error is thrown.

### --feedback--

The lesson explains the default behavior when the `action` attribute is missing.

---

The form data is sent to a default server.

### --feedback--

The lesson explains the default behavior when the `action` attribute is missing.

## --video-solution--

2

## --text--

Which `enctype` value should be used when a form includes file uploads?

## --answers--

`application/x-www-form-urlencoded`

### --feedback--

The lesson mentions a specific `enctype` for handling forms with file uploads.

---

`text/plain`

### --feedback--

The lesson mentions a specific `enctype` for handling forms with file uploads.

---

`multipart/form-data`

---

`application/json`

### --feedback--

The lesson mentions a specific enctype for handling forms with file uploads.

## --video-solution--

3
