---
id: 6734061fe116df617a564a37
title: What Is Currying, and How Does It Work?
challengeType: 19
dashedName: what-is-currying-and-how-does-it-work
---

# --interactive--

Currying is a technique where we transform a function that takes multiple arguments into a sequence of functions, each taking a single argument.

Let's start with a basic example. Imagine we have a function that adds two numbers:

:::interactive_editor

```js
function add(a, b) {
  return a + b;
}

console.log(add(3, 4)); // 7
```

:::

This is a function that takes two arguments and returns their sum. Now, let's see how we can curry this function:

:::interactive_editor

```js
function curriedAdd(a) {
  return function(b) {
    return a + b;
  }
}

console.log(curriedAdd(3)(4)); // 7
```

:::

In this curry converted code, instead of taking two arguments at once, we have a function that takes the first argument and returns another function. This returned function then takes the second argument and performs the addition. We call it like `curriedAdd(3)(4)`, where each pair of parentheses represents a function call.

But why would we want to do this? 

Currying allows us to create some special functions easily. For example, we could create a function that always adds five to any number:

:::interactive_editor

```js
function curriedAdd(a) {
  return function(b) {
    return a + b;
  }
}

const addFive = curriedAdd(5);
console.log(addFive(10)); // 15
console.log(addFive(20)); // 25
```

:::

Here, `addFive` is a function that's always ready to add five to whatever number we give it. This is a simple example of partial application, where we fix a certain number of arguments to a function, producing another function that takes fewer arguments.

While our examples have focused on functions with two arguments, currying can be applied to functions with any number of arguments.

As you continue your journey in JavaScript, you'll likely find many situations where currying can make your code cleaner and more expressive.

# --questions--

## --text--

What is the primary purpose of currying in functional programming?

## --answers--

To make functions run faster.

### --feedback--

Think about how currying changes the way we pass arguments to a function.

---

To transform a function with multiple arguments into a sequence of functions with single arguments.

---

To eliminate the need for function parameters.

### --feedback--

Think about how currying changes the way we pass arguments to a function.

---

To combine multiple functions into one.

### --feedback--

Think about how currying changes the way we pass arguments to a function.

## --video-solution--

2

## --text--

In the context of currying, what is partial application?

## --answers--

Applying a function to only some of its arguments.

---

Applying a function to all of its arguments at once.

### --feedback--

Recall what we said about "fixing" some arguments to a function.

---

Creating a new function from scratch.

### --feedback--

Recall what we said about "fixing" some arguments to a function.

---

Splitting a function into multiple smaller functions.

### --feedback--

Recall what we said about "fixing" some arguments to a function.

## --video-solution--

1

## --text--

Which of the following is an example of a curried function in JavaScript?

## --answers--

```js
function add(a, b, c) {
  return a + b + c;
}
```

### --feedback--

This is a regular function that takes all parameters at once.

---

```js
function add(a) {
  return function (b) {
    return function (c) {
      return a + b + c;
    };
  };
}
```

---

```js
function add(a, b, c) {
  return a() + b() + c();
}
```

### --feedback--

This function accepts all parameters at once and calls them like functions, which does not follow the definition of a curried function.

---

```js
function add(a) {
  function inner(b) {
    return a + b;
  }
}
```

### --feedback--

The inner function is never returned, so `add(2)` will return `undefined` and `add(2)(3)` will throw an error.

## --video-solution--

2
