---
id: 67083952f800051a8a21fcfd
title: What Is the Role of the Meta Description, and How Does It Affect SEO?
challengeType: 19
dashedName: what-is-the-role-of-the-meta-description
---

# --description--

SEO, or Search Engine Optimization, is a practice that optimizes web pages so they become more visible and rank higher on search engines. One way to improve your site's SEO, is to provide a short description for the web page using the `meta` element. Here is an example of using the meta element to set a page description for a gardening site:

```html
<meta
  name="description"
  content="Discover expert tips and techniques for gardening in small spaces, choosing the right plants, and maintaining a thriving garden."
/>
```

By setting the `name` attribute to `description`, it ensures that browsers, search engines, and other web tools correctly interpret this metadata. The `content` attribute is where you will place your description. It is recommended that you keep your descriptions short and concise. This is because search engines will often truncate the description based on the results page layout.

Similar to other types of `meta` elements, the `meta` description will not be visible on the web page itself. One place where the page description can be found is in the search engine results page snippet. Here are some examples of page result snippets for freeCodeCamp's subreddit and GitHub repositories:

```sh
r\FreeCodeCamp: This is the official subreddit for the freeCodeCamp.org community. Learn to
code for free together with millions of other people...
```

```sh
Our full-stack web development and machine learning curriculum is completely free and self-
paced. We have thousands of interactive coding challenges to help you...
```

In the examples, each of the page descriptions are located just beneath the site links. Within a couple of seconds, users can get a general sense of what the page is about and decide to click on the links for more information.

Even though `meta` descriptions won't directly affect a site's ranking on search engine, having a strong description could result in more traffic to your website.

# --questions--

## --text--

Which element is used to set the description for a web page?

## --answers--

`img`

### --feedback--

Look closely to the title of this lesson.

---

`meta`

---

`slot`

### --feedback--

Look closely to the title of this lesson.

---

`figure`

### --feedback--

Look closely to the title of this lesson.

## --video-solution--

2

## --text--

What does SEO stand for?

## --answers--

Slot Engine Optimization

### --feedback--

Refer back to where SEO was talked about.

---

Site Enhancement Outreach

### --feedback--

Refer back to where SEO was talked about.

---

Social Engagement Optimization

### --feedback--

Refer back to where SEO was talked about.

---

Search Engine Optimization

## --video-solution--

4

## --text--

Where does the page's description typically show up?

## --answers--

Inside the `figure` element.

### --feedback--

Refer back to where there are examples showing where the page's descriptions typically show up.

---

Inside the `footer` element.

### --feedback--

Refer back to where there are examples showing where the page's descriptions typically show up.

---

In the search engine results page.

---

In a popup alert message.

### --feedback--

Refer back to where there are examples showing where the page's descriptions typically show up.

## --video-solution--

3
