---
id: 673403d2aa52d8586a14a269
title: What Is Class Inheritance, and How Does It Work?
challengeType: 19
dashedName: what-is-class-inheritance-and-how-does-it-work
---
 
# --interactive--

In programming, inheritance allows you to define classes that inherit properties and methods from other classes.

For example, a `Car` is a type of `Vehicle`, so you could define a `Vehicle` class with the most general properties and methods that are common to all types of vehicles and then define a `Car` class that inherits the properties and methods of the `Vehicle` class.

This "is a" relationship is characteristic of inheritance. In this example, `Car` is a more specialized form of `Vehicle`.

There are two main concepts that you should know about to start working with inheritance: parent class and child class.

A parent class is a class that acts like a blueprint for other classes. It defines properties and methods that are inherited by other classes.

A child class is a class that inherits the properties and methods of another class. Child classes can also extend the functionality of their parent classes by adding new properties and methods.

In our previous example, `Vehicle` would be the parent class of the `Car` class while the `Car` class would be the child class of `Vehicle`.

A parent class can have multiple child classes.

In JavaScript, we use the `extends` keyword to implement inheritance. This keyword indicates that a class is the child class of another class.

In this example, in which we only have the first lines of the class definitions, you can see that the `Car` class extends the `Vehicle` class, so `Car` inherits from `Vehicle`.

```js
class Vehicle {
  // Implementation of Vehicle...
}

class Car extends Vehicle {
  // Implementation of Car...
}
```

Let's say that the `Vehicle` class has two properties: `brand` and `year`. You can see this in the updated code.

`Car` has a method called `honk`. However, notice that the `Car` class doesn't have its own constructor. Let's see if it does inherit the properties.

```js
class Vehicle {
  constructor(brand, year) {
    this.brand = brand;
    this.year = year;
  }
}

class Car extends Vehicle {
  honk() {
    console.log("Honk! Honk!");
  }
}
```

To define an instance of `Car`, you'll need to pass two arguments: `brand` and `year`. In this case, the brand is `freeCodeCamp Motors` and the year is `2019`.

```js
let myCar = new Car("freeCodeCamp Motors", 2019);
```

If you try to access these properties and call the method using dot notation:

```js
console.log(myCar.brand);
console.log(myCar.year);
myCar.honk();
```

Here is the full example:

:::interactive_editor

```js
class Vehicle {
  constructor(brand, year) {
    this.brand = brand;
    this.year = year;
  }
}

class Car extends Vehicle {
  honk() {
    console.log("Honk! Honk!");
  }
}

let myCar = new Car("freeCodeCamp Motors", 2019);
console.log(myCar.brand);
console.log(myCar.year);
myCar.honk();
```

:::

Indeed, the output is correct, so these properties and method are defined in the `Car` instance and you just saved yourself a lot of code repetition by inheriting these properties from the `Vehicle` class.

In this example, the child class didn't have any additional properties. That's why the class didn't have a constructor, only a method.

If you do need to add additional properties, you'll need to define a constructor.

Let's see an example.


```js
class Vehicle {
  constructor(brand, year) {
    this.brand = brand;
    this.year = year;
  }
}

class Car extends Vehicle {
  constructor(brand, year, numDoors) {
    super(brand, year);
    this.numDoors = numDoors;
  }
}
```

This time, we'll add a `numDoors` property to the `Car` subclass.

You can see that now this class has a constructor in the updated code. Within the constructor, there's a call to `super()`, passing the arguments `brand` and `year`.

`super()` invokes the constructor of the superclass, so by using `super(brand, year)` you will essentially be defining the properties of the superclass in the subclass. This is another terminology you can use- superclass is the parent class and the subclass is the child class.

Then, `this.numDoors = numDoors` line defines a new property that belongs exclusively to the `Car` class, the number of doors (`numDoors`).

This is a way to extend the `Vehicle` class, adding a property that is exclusive to `Car` instances.

That's is an example of extensibility, one of the fundamental advantages of inheritance.

Now, if you create an instance of the `Car` class, you'll see that it has the three properties: `brand`, `year`, and `numDoors`. You'll also need to pass the necessary arguments when you create the instance.

```js
let myCar = new Car("freeCodeCamp Motors", 2019, 4);
```

If you print the values of these properties with `console.log()`:

```js
console.log(myCar.brand);
console.log(myCar.year);
console.log(myCar.numDoors);
```

Here is the full example:

:::interactive_editor

```js
class Vehicle {
  constructor(brand, year) {
    this.brand = brand;
    this.year = year;
  }
}

class Car extends Vehicle {
  constructor(brand, year, numDoors) {
    super(brand, year);
    this.numDoors = numDoors;
  }
}

let myCar = new Car("freeCodeCamp Motors", 2019, 4);
console.log(myCar.brand);
console.log(myCar.year);
console.log(myCar.numDoors);
```

:::

The main advantages of inheritance are code reusability, modularity, extensibility, and improved code structure.

By implementing a hierarchy, you can reuse code that you already wrote for a parent class in the child class, avoiding repetition.

Inheritance also promotes modularity by breaking down complex systems into simpler components in the hierarchy.

Also, being able to extend the functionality of the parent class makes it easier to adapt to changing requirements and add new features later on in the development process.

Finally, the hierarchical structure can make your code easier to understand and maintain.

Those are the fundamentals of inheritance. By understanding how inheritance works, you can design well-structured, maintainable, and extensible object-oriented programs.

# --questions--

## --text--

What is the primary purpose of inheritance in object-oriented programming?

## --answers--

To create new objects.

### --feedback--

Think about how inheritance helps with code reusability and organization.

---

To define methods for a class.

### --feedback--

Think about how inheritance helps with code reusability and organization.

---

To reuse code and create hierarchical relationships between classes.

---

To encapsulate data within objects.

### --feedback--

Think about how inheritance helps with code reusability and organization.

## --video-solution--

3

## --text--

What is the keyword used to inherit from a parent class in JavaScript?

## --answers--

`inherit`

### --feedback--

Think about the keyword that establishes the inheritance relationship.

---

`extends`

---

`super`

### --feedback--

Think about the keyword that establishes the inheritance relationship.

---

`prototype`

### --feedback--

Think about the keyword that establishes the inheritance relationship.

## --video-solution--

2

## --text--

What is the difference between a parent class and a child class?

## --answers--

A parent class is a specialized version of a child class.

### --feedback--

Think about the hierarchical relationship between classes.

---

A child class is a specialized version of a parent class.

---

There is no difference between parent and child classes.

### --feedback--

Think about the hierarchical relationship between classes.

---

Parent classes are always larger than child classes.

### --feedback--

Think about the hierarchical relationship between classes.

## --video-solution--

2
