---
id: 672c3aa9bc3a481425cb52b3
title: What Is the Z-Index Property, and How Does It Work to Control the Stacking of Positioned Elements?
challengeType: 19
dashedName: what-is-the-z-index-property
---

# --interactive--

The `z-index` property in CSS is used to control the vertical stacking order of positioned elements that overlap on the page. When multiple elements are stacked on top of each other, the `z-index` value determines which element appears on top. The higher the `z-index` value, the closer the element is to the viewer, while lower values place the element farther back in the stack.

However, the `z-index` only works on elements that are positioned, which means the element must have a position value other than `static`, such as `relative`, `absolute`, or `fixed`. The default `z-index` value is `auto`, which places the element in the default stacking order. Let's take a look at an example with three boxes:

```html
<div class="container">
  <div class="box1">Box 1</div>
  <div class="box2">Box 2</div>
  <div class="box3">Box 3</div>
</div>
```

Now, we can apply some styles to position the boxes to overlap on each other like this:

:::interactive_editor

```html
<link rel="stylesheet" href="styles.css">
<div class="container">
  <div class="box1">Box 1</div>
  <div class="box2">Box 2</div>
  <div class="box3">Box 3</div>
</div>
```

```css
.container {
  position: relative;
  width: 300px;
  height: 300px;
  border: 1px solid black;
}

.box1 {
  position: absolute;
  z-index: 1;
  background: lightcoral;
  top: 20px;
  left: 20px;
  width: 100px;
  height: 100px;
}

.box2 {
  position: absolute;
  z-index: 3;
  background: gold;
  top: 40px;
  left: 40px;
  width: 100px;
  height: 100px;
}

.box3 {
  position: absolute;
  z-index: 2;
  background: lightgreen;
  top: 60px;
  left: 60px;
  width: 100px;
  height: 100px;
}
```

:::

For the container, the positioning will be set to `relative` and all of the boxes nested inside will be set to `absolute` positioning. Each box has a different value for the `z-index` which results in the boxes being layered on top of each other.

You can think of `z-index` as a way to create layers on a webpage, and elements with higher `z-index` values will be placed above those with lower values. This is especially useful for controlling how overlapping elements behave in complex layouts, such as modals, pop-ups, or tooltips.

# --questions--

## --text--

What does the `z-index` property control in CSS?

## --answers--

The color of an element.

### --feedback--

`z-index` is responsible for how elements overlap visually.

---

The vertical stacking order of positioned elements.

---

The size of an element.

### --feedback--

`z-index` is responsible for how elements overlap visually.

---

The horizontal alignment of text.

### --feedback--

`z-index` is responsible for how elements overlap visually.

## --video-solution--

2

## --text--

In order for the `z-index` property to work, what must be true about the element?

## --answers--

It must have a `fixed` width.

### --feedback--

Consider what enables an element to be placed in a stacking context.

---

It must have a `position` value other than `static`.

---

It must have a `display` value of `block`.

### --feedback--

Consider what enables an element to be placed in a stacking context.

---

It must have a background color set.

### --feedback--

Consider what enables an element to be placed in a stacking context.

## --video-solution--

2

## --text--

Which `z-index` value places an element on top of all others?

## --answers--

`z-index: 0;`

### --feedback--

Think about which number is highest and how `z-index` works.

---

`z-index: 5;`

---

`z-index: auto;`

### --feedback--

Think about which number is highest and how `z-index` works.

---

`z-index: -1;`

### --feedback--

Think about which number is highest and how z-index works.

## --video-solution--

2
