---
id: 66f6db08d55022680a3cfbc9
title: What Role Does HTML Play on the Web?
challengeType: 19
dashedName: what-is-html
---

# --interactive--

HTML, which stands for Hypertext Markup Language, is a markup language for creating web pages. When you visit a website and see content like paragraphs, headings, links, images, and videos; that's HTML. 

Here is a small example using HTML elements. Try editing some of the text in the editor and see the changes update in the preview window.

:::interactive_editor

```html
<h1>Main heading element</h1>

<p>I am a paragraph element.</p>
```

:::

HTML represents the content and structure of a webpage through the use of elements. Most elements will have an opening tag and a closing tag. Sometimes those tags are referred to as start and end tags. In between those two tags, you will have the content. This content can be text or other HTML elements. 

Here is another example of a paragraph element. Change the text in the editor to say `I love coding!` and see the results in the preview window. 

:::interactive_editor

```html
<p>I am a paragraph element.</p>
```

:::

Both opening and closing tags start with a left angle bracket (`<`), and end with a right angle bracket (`>`), with the tag name placed between these angle brackets. While HTML tag names are case-insensitive, it is a widely accepted convention and best practice to write them in lowercase. 

Here is a closer look at just the opening and closing paragraph tags:

```html
<p>
```

```html
</p>
```

What distinguishes an opening tag from a closing tag is the forward slash (`/`) placed immediately after the left angle bracket in a closing tag. Some HTML elements do not have a closing tag. These are known as void elements.

Here is an example of an image element which is a void element:

```html
<img>
```

Notice that this image element does not have the closing tag and it does not have any content. Void elements cannot have any content and only have a start tag.

Sometimes you will see void elements that use a `/` before the `>` like this:

```html
<img />
```

While many code formatters like Prettier, will choose to include the `/` in void elements, the HTML spec states that the presence of the `/` "does not mark the start tag as self-closing but instead is unnecessary and has no effect of any kind".

In real world development, you will see both forms so it is important to be familiar with both.

If you wanted to display an image, you will need to include a couple of attributes inside your image element. An attribute is a special value used to adjust the behavior for an HTML element. 

Here is an example of an image element with a `src` attribute. Update the value of the `src` attribute to `"https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg"` and you will see the image change to two cats peacefully sleeping.

:::interactive_editor

```html
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg" />
```

:::

The `src` attribute is used to specify the location for that image. For image elements, it's good practice to include another attribute called the `alt` attribute. The `alt` attribute is used to provide short, descriptive text for the images.

Here's an example of an image element with the `src` and `alt` attributes. Try breaking the image by updating the `src` value to `"https://.freecodecamp.org/curriculum/cat-photo-app/cats.jpg"`. You will see the image disappear and only the `alt` text show.  

:::interactive_editor

```html
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg" alt="Two tabby kittens sleeping together on a couch." />
```

:::

So, you might be wondering if HTML by itself is enough to build a website. Well, the answer is: it depends. If you're building a small practice project that only displays text and images, HTML alone might be sufficient. However, if you're creating a modern professional website, you will need to have HTML, CSS, and JavaScript.

HTML is for the content and structure. CSS is for styling. JavaScript is for adding interactivity to your web pages. A good analogy for this is to compare HTML, CSS, and JavaScript with a complete building. 

HTML represents the blocks, concrete, and irons that make up the walls. It's the foundation that makes the building strong. CSS represents the interior and exterior design that makes the house look beautiful. JavaScript represents the electrical and water system that ensures uninterrupted access to water and electricity.

# --questions--

## --text--

What does HTML stand for?

## --answers--

HyperText Maker Language

### --feedback--

Refer to the section where HTML was introduced.

---

HyperText Marker Language

### --feedback--

Refer to the section where HTML was introduced.

---

HyperText Markdown Language

### --feedback--

Refer to the section where HTML was introduced.

---

HyperText Markup Language

## --video-solution--

4

## --text--

Which of the following is the correct syntax for a closing tag?

## --answers--

`<;p>`

### --feedback--

Think about the additional symbol for defining tags apart from left-angle and right-angle brackets.

---

`<p>`

### --feedback--

Think about the additional symbol for defining tags apart from left-angle and right-angle brackets.

---

`</p>`

---

`<///p/>`

### --feedback--

Think about the additional symbol for defining tags apart from left-angle and right-angle brackets.

## --video-solution--

3

## --text--

Which of the following is a valid attribute used inside the `img` element?

## --answers--

`src`

---

`bold`

### --feedback--

Review where the `img` element and the appropriate attributes were discussed.

---

`closing`

### --feedback--

Review where the `img` element and the appropriate attributes were discussed.

---

`div`

### --feedback--

Review where the `img` element and the appropriate attributes were discussed.

## --video-solution--

1
