---
id: 6708143cab2b583ecd3324f5
title: What Are Attributes, and How Do They Work?
challengeType: 19
dashedName: what-are-attributes
---

# --interactive--

An attribute is a value placed inside the opening tag of an HTML element. Attributes provide additional information about the element or specify how the element should behave. Here is the basic syntax for an attribute:

```html
<element attribute="value"></element>
```

The attribute name is followed by an equal sign (`=`) and a value in quotes. The value can be a string or a number, depending on the attribute.

This first example uses the `href` and `target` attributes. The `href` attribute specifies the URL of a link and the `target` attribute specifies where to open the link.

Enable the interactive editor and change the `href="https://www.freecodecamp.org/news/"` to `href="https://www.freecodecamp.org"`. Now when you click on the link in the interactive editor, you will see the freeCodeCamp homepage in a new browser tab.

:::interactive_editor

```html
<a href="https://www.freecodecamp.org/news/" target="_blank">Visit freeCodeCamp</a>
```

:::

Without the `href` attribute, the link would not work because there would be no destination URL. So you must include this `href` attribute to make the link functional. The `target="_blank"` enables the link to open in a new browser tab. You will learn more about the `target` attribute in future lessons.

Other common attributes are the `src`, and `alt`, or alternative, attribute - which is used to specify the source of an image and provide alternative descriptive text for the image, respectively. 

Enable the interactive editor and change the `src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg"` to `src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/running-cats.jpg"`. Then change the `alt="Two tabby kittens sleeping together on a couch."` to `alt="Two cats running in the dirt."`.

:::interactive_editor

```html
<img src="https://cdn.freecodecamp.org/curriculum/cat-photo-app/cats.jpg" alt="Two tabby kittens sleeping together on a couch." />
```

:::

Similar to the `href` attribute, the `src` attribute is required because it specifies the image file to be displayed. The `alt` attribute is not required, but it is recommended for accessibility purposes. Accessibility means making sure that everyone, including those with disabilities, can use and understand things like websites, apps, and physical spaces. You will learn more about accessibility in the upcoming lessons.

Some attributes are a little unique with their syntax like the `checked` attribute.

Enable the interactive editor and try clicking on the checkbox in the preview window to see it alternate between a checked and unchecked state.

:::interactive_editor

```html
<input type="checkbox" checked />
```

:::

In the following example, we have an `input` element with the `type` attribute set to `checkbox`. Inputs are used to collect data from users, and the `type` attribute specifies the type of input. In this case, this input is a checkbox. You will learn more about how inputs work in the upcoming lessons. 

The `checked` attribute is used to specify that the checkbox should be checked by default. The `checked` attribute does not require a value. If it is present, the checkbox will be checked by default. If the attribute is not present, the checkbox will be unchecked. This is known as a boolean attribute. You will learn more about booleans in general when you get to the JavaScript section. 

Enable the interactive editor and try remove the `checked` attribute from the `input`. You will see that the checkbox is no longer checked by default. 

:::interactive_editor

```html
<input type="checkbox" checked />
```

:::

There are several common boolean attributes you will encounter in HTML, such as `disabled`, `readonly`, and `required`. These attributes are used to specify the state of an element, such as whether it is disabled, read-only, or required.

Here is an example of a text `input` element that is disabled by default. Enable the interactive editor and try clicking on the `input` element in the preview window. Now remove the `disabled` attribute from the `input` element and you will see that the `input` is no longer disabled by default. You should now be able to click on it and type inside the field.

:::interactive_editor

```html
<input type="text" disabled>
```

:::

HTML has many attributes that can be used to customize the behavior and appearance of elements on a webpage. Understanding how to use attributes is essential for creating interactive and accessible web content. Over the next few lessons, you will learn about more HTML attributes and how to use them effectively in your web development projects.

# --questions--

## --text--

Which of the following is an example of a boolean attribute?

## --answers--

`src`

### --feedback--

Refer to the section where common boolean attributes were discussed.

---

`href`

### --feedback--

Refer to the section where common boolean attributes were discussed.

---

`disabled`

---

`alt`

### --feedback--

Refer to the section where common boolean attributes were discussed.

## --video-solution--

3

## --text--

What is the role of an attribute in HTML?

## --answers--

Attributes provide additional information and help define the behavior for HTML elements.

---

Attributes change the background color of an element.

### --feedback--

Refer to the section where the definition for attributes was discussed.

---

Attributes change the font size of an element.

### --feedback--

Refer to the section where the definition for attributes was discussed.

---

Attributes add JavaScript functionality to an element.

### --feedback--

Refer to the section where the definition for attributes was discussed.

## --video-solution--

1

## --text--

Which of the following is the correct syntax for a boolean attribute?

## --answers--

`<input type="checkbox" checked>`

---

`<input type="checkbox" checked="on">`

### --feedback--

Refer to the section where the `checked` attribute was discussed.

---

`<input type="checkbox" checked="off">`

### --feedback--

Refer to the section where the `checked` attribute was discussed.

---

`<input type="checkbox" checked="isChecked">`

### --feedback--

Refer to the section where the `checked` attribute was discussed.

## --video-solution--

1
