---
id: 67329fd6ad99c75d4a4b74e4
title: What Is a Module in JavaScript, and How Can You Import and Export Modules in Your Program?
challengeType: 19
dashedName: what-is-a-module-in-javascript-and-how-can-you-import-and-export-modules-in-your-program
---

# --description--

In JavaScript, a module is a self-contained unit of code that encapsulates related functions, classes, or variables.

Think of a module as a building block for your application, much like a chapter in a book. Each module focuses on a specific functionality, making your code more organized, maintainable, and reusable. Modules help prevent naming conflicts and allow you to structure your application into separate, interconnected pieces.

The concept of modules in JavaScript has evolved over time, but the most widely used and supported approach is the ES6 (ECMAScript 2015) module system. This system provides a standardized way to define and use modules across different JavaScript environments.

To create a module, you write your JavaScript code in a separate file. Any variables, functions, or classes you want to make available to other parts of your application need to be explicitly exported. You can do this using the `export` keyword.

For example, let's say you have a file called `math.js` with some math functions:

```js
export function add(a, b) {
    return a + b;
}

export function subtract(a, b) {
    return a - b;
}

const PI = 3.14159;
export { PI };
```

In this example, we're exporting two functions (`add` and `subtract`) and a constant (`PI`). You can export as many items as you need from a single module.

To use these exported items in another part of your application, you need to import them. This is done using the `import` keyword.

Let's say you want to use these math functions in a file called `app.js`:

```js
import { add, subtract, PI } from './math.js';

console.log(add(5, 3));        // Outputs: 8
console.log(subtract(10, 4));  // Outputs: 6
console.log(PI);               // Outputs: 3.14159
```

Here, we're importing the specific functions and constant we need from the `math.js` module. The `'./math.js'` part tells JavaScript where to find the module file relative to the current file.

Sometimes, you might want to import everything a module exports. You can do this using the asterisk (`*`) syntax:

```js
import * as Math from './math.js';

console.log(Math.add(5, 3));        // Outputs: 8
console.log(Math.subtract(10, 4));  // Outputs: 6
console.log(Math.PI);               // Outputs: 3.14159
```

In this case, all exports from `math.js` are imported as properties of an object called `Math`.

Another common pattern is to have a default export in a module. This is typically used when a module primarily exports a single function. You can only have one default export per module.

Here's how it looks:

```js
// In math.js
export default function multiply(a, b) {
    return a * b;
}

// In app.js
import multiply from './math.js';

console.log(multiply(4, 5));  // Outputs: 20
```

Notice that when importing a default export, you don't need to use curly braces, and you can name the import whatever you want.

It's important to note that to use ES6 modules in the browser, you need to specify the `type` as `module` in your `script` tag:

```html
<script type="module" src="app.js"></script>
```

Modules provide a powerful way to organize and structure your JavaScript code. They allow you to break your application into smaller, manageable pieces, promote code reuse, and help maintain a clean separation of concerns. As you build larger applications, you'll find that modules become an essential tool in your JavaScript development toolkit.

# --questions--

## --text--

What keyword is used to make functions, variables, or classes available to other modules?

## --answers--

`import`

### --feedback--

Think about the keyword we use to make items accessible outside their original module.

---

`export`

---

`module`

### --feedback--

Think about the keyword we use to make items accessible outside their original module.

---

`require`

### --feedback--

Think about the keyword we use to make items accessible outside their original module.

## --video-solution--

2

## --text--

How do you import a default export from a module?

## --answers--

`import { default } from './module.js';`

### --feedback--

Remember the special syntax we discussed for importing default exports.

---

`import default from './module.js';`

### --feedback--

Remember the special syntax we discussed for importing default exports.

---

`import * as default from './module.js';`

### --feedback--

Remember the special syntax we discussed for importing default exports.

---

`import anyName from './module.js';`

## --video-solution--

4

## --text--

What is the purpose of using modules in JavaScript?

## --answers--

To make the code run faster.

### --feedback--

Consider the main advantages of using modules that we discussed.

---

To reduce the file size of the application.

### --feedback--

Consider the main advantages of using modules that we discussed.

---

To organize code into manageable, reusable pieces.

---

To encrypt sensitive parts of the code.

### --feedback--

Consider the main advantages of using modules that we discussed.

## --video-solution--

3
