---
id: 672995ac85fd943657c2ede5
title: When Should You Use the Strong Element Over the Bring Attention To Element?
challengeType: 19
dashedName: when-should-you-use-the-strong-element-over-the-bring-attention-to-element
---

# --interactive--

The "bring attention to" element, `b`, is commonly used to highlight keywords in summaries, or product names in reviews. Usually, browsers display this text in boldface. Here's an example using the `b` element to highlight product names in this review:

:::interactive_editor

```html
<p>
  We tested several products, including the <b>SuperSound 3000</b> for audio
  quality, the <b>QuickCharge Pro</b> for fast charging, and the
  <b>EcoClean Vacuum</b> for cleaning. The first two performed well, but the
  <b>EcoClean Vacuum</b> did not meet expectations.
</p>
```

:::

The browser renders these parts of the text as bold text. This visual emphasis will draw readers attention to the product names.

If you need to emphasize the importance of the text, you should use the `strong` element instead of the `b` element.

`strong` is a semantic HTML element that emphasizes text that is crucial, or urgent. This is an example where the `strong` element is used to label a very important warning about the potential allergic reactions that customers may have to a product:

:::interactive_editor

```html
<p>
  <strong>Warning:</strong> This product may cause allergic reactions.
</p>
```

:::

The `strong` element communicates that sense of urgency.

Visually both are very similar, because they are both rendered as bold by default. But their meanings are quite different. While the "bring attention to" element only draws attention to the text, without indicating the higher level of importance, the `strong` element does more than that. It conveys a sense of importance, or urgency. This is their main difference. 

To choose between them, consider the purpose of the text and its importance within the surrounding content.

# --questions--

## --text--

Which HTML element is used to draw attention to a specific part of the text without conveying specific importance?

## --answers--

`strong`

### --feedback--

Think about the element that primarily affects text style.

---

`mark`

### --feedback--

Think about the element that primarily affects text style.

---

`em`

### --feedback--

Think about the element that primarily affects text style.

---

`b`

## --video-solution--

4

## --text--

Which HTML element is used to indicate text that is specially important or urgent?

## --answers--

`strong`

---

`b`

### --feedback--

Think about the semantic HTML element that conveys the importance of the text.

---

`em`

### --feedback--

Think about the semantic HTML element that conveys the importance of the text.

---

`mark`

### --feedback--

Think about the semantic HTML element that conveys the importance of the text.

## --video-solution--

1

## --text--

What is the primary difference between `b` and `strong`?

## --answers--

There is no difference – they both make the text bold.

### --feedback--

Think about the semantic meaning of each element.

---

`b` is for visual emphasis, while `strong` is for emphasizing importance.

---

`strong` is for styling, while `b` is for emphasizing importance.

### --feedback--

Think about the semantic meaning of each element.

---

They are both used for presentational purposes only.

### --feedback--

Think about the semantic meaning of each element.

## --video-solution--

2
