---
id: 672995bda6c67e369aaf8588
title: What Are Description Lists, and When Should You Use Them?
challengeType: 19
dashedName: what-are-description-lists
---

# --interactive--

Description lists are perfect for presenting terms and definitions in an organized and easy-to-read format, like in a glossary, or real dictionary, where you can find words with their corresponding definitions.

This is an example of a description list in HTML with two terms and their corresponding details.

Enable the interactive editor and try uncommenting the code to see the new detail item show up in the preview window.

:::interactive_editor

```html
<dl>
  <dt>HTML</dt>
  <dd>HyperText Markup Language</dd>
  <dt>CSS</dt>
  <dd>Cascading Style Sheets</dd>
  <!-- <dt>JS</dt>
  <dd>JavaScript</dd> -->
</dl>
```

:::

In this case the terms are the acronyms HTML and CSS, and the details are their expansions. The details could also be definitions, or other information related to the terms.

You will need three HTML elements to define a description list. First, the description list element, `dl`, which is the container for the entire list. You can see it wraps around all the other elements of the description list in the example.

Then, one description term element, `dt`, for each term. In this case the description list has two terms, HTML and CSS, so it has two of these elements.

And finally, after each term you will find a description details element, `dd`, for the description, or details associated with that term. In this example, they are Hypertext Markup Language and Cascading Style Sheets.

In the browser, you would see each term followed by its corresponding description. By default, the descriptions are slightly more indented towards the right to distinguish them visually.

But description lists are not limited to only terms and definitions. They are much more versatile than that. Here we have a recipe with two ingredients.

Enable the interactive editor and try uncommenting the code to see the new detail item show up in the preview window.

:::interactive_editor

```html
<dl>
  <dt>Flour</dt>
  <dd>2 cups</dd>
  <dt>Sugar</dt>
  <dd>1/2 cup</dd>
  <!-- <dt>Vegetable Oil</dt>
  <dd>2 tablespoons</dd> -->
</dl>
```

:::

The entire description list is within a description list element. The first ingredient, `Flour`, is within a description term element. Then, you can see how much of this ingredient you will need: `2 cups`. This is within a description details element directly after its corresponding ingredients.

And the same structure is repeated for `Sugar`. In this case, the recipe has only two ingredients, but if there were more the same structure could be repeated throughout the description list.

In the browser, you would see the ingredients aligned to the left, and the measurements indented to separate them visually.

Other use cases for description lists include product specifications, frequently asked questions, contact information, and metadata. Essentially, when you have two related pieces of information in a key-value pair format, where one acts as a label, the key, and the other acts as additional related information, the value, you can use a description list.

# --questions--

## --text--

Which HTML tag is used to define an entire description list?

## --answers--

`dt`

### --feedback--

Think about the HTML element that contains all the other elements of a description list.

---

`dd`

### --feedback--

Think about the HTML element that contains all the other elements of a description list.

---

`dl`

---

`li`

### --feedback--

Think about the HTML element that contains all the other elements of a description list.

## --video-solution--

3

## --text--

Which HTML tag is used to represent a term in a description list?

## --answers--

`dl`

### --feedback--

Think about the elements of the description list that come before the details or definitions.

---

`dt`

---

`dd`

### --feedback--

Think about the elements of the description list that come before the details or definitions.

---

`li`

### --feedback--

Think about the elements of the description list that come before the details or definitions.

## --video-solution--

2

## --text--

Which HTML tag is used to define or provide more details about a term in a description list?

## --answers--

`dl`

### --feedback--

Think about the elements of a description list that provide additional details about the terms.

---

`dt`

### --feedback--

Think about the elements of a description list that provide additional details about the terms.

---

`dd`

---

`li`

### --feedback--

Think about the elements of a description list that provide additional details about the terms.

## --video-solution--

3
