---
id: 67d1d6af27858c4f487d3f4c
title: What Is the Difference Between Real Performance and Perceived Performance?
challengeType: 19
dashedName: what-is-the-difference-between-real-performance-and-perceived-performance
---

# --description--

When we talk about performance, the term itself can feel a bit subjective, right? What is good performance? What is bad performance?

Is there a standard way to measure performance or is it completely dependent on the user's personal preferences and perception? Let's see. 

We can classify a website's performance into two different categories: perceived performance and real performance.

The perceived performance is how users perceive the performance of a website. It's how they evaluate it in terms of responsiveness and reliability. This is a subjective measurement, so it's hard to quantify it, but it's very important, since the user experience determines the success or failure of a website.

In contrast, real performance is the objective and measurable performance of the website. It's measured using metrics like page load time, server response time, and rendering time. These measurements are influenced by multiple factors related to the network and to the code itself.

Even a website with excellent perceived performance can be further optimized for an even better user experience.

There are several techniques for improving perceived performance.

Reducing the initial load time as much as possible by loading non-essential resources in the background is essential. This technique is known as "lazy loading." That first impression can determine what users will think about your website.

Lazy loading will also impact the real performance of your website. By using this technique, you can reduce the amount of content that has to be loaded upfront, so the page will load faster, which is a real performance metric.

It's also very important to provide quick response and feedback to user interactions. 

For example, showing a loading indicator for a long-running process as soon as the user clicks on an element can help the user feel connected and engaged with the process, making the wait time feel shorter - or at least they'll feel more involved.

Keeping users actively engaged with your website is very important for improving their time perception. Displaying text as soon as it arrives is helpful for keeping users engaged from the start, even if other resources, like images, have not been loaded yet.

If a user is waiting for a long-running task to be completed, keep them informed on the progress and update it regularly.

Another tip is to avoid content reflow and jumping content. For example, when ads or images are being loaded, the website might jump or readjust to make room for these new resources if they don't already have a space in the layout. 

These sudden changes can result in a bad user experience because users may feel like the website is still loading. To avoid this, plan ahead and assign space for these elements from the start.

If your website has custom fonts, you should also try to minimize font loading delays, since this may result in flickering - or showing the fallback font while the custom font is being loaded. A suggestion for this is using a fallback font that is similar to the custom font, so in case this happens, the change will be much more subtle.

Also, be sure that the interface elements are active. The user should be able to interact with them with minimal lag.

We will go into these techniques in more detail in the next few lessons.

While real performance is important, perceived performance can have a tremendous impact on user experience. By optimizing for both, you can create websites that are and feel faster, creating a smooth and engaging user experience.

# --questions--

## --text--

What is the primary difference between real performance and perceived performance?

## --answers--

Real performance is measured by user experience, while perceived performance is measured by technical metrics.

### --feedback--

Think about how a website can be technically fast but feel slow to a user.

---

Real performance is measured by technical metrics, while perceived performance is measured by user experience.

---

There is no difference between real and perceived performance. They are equivalent because both refer to how users experience the performance of a website.

### --feedback--

Think about how a website can be technically fast but feel slow to a user.

---

Perceived performance is more important than real performance because it is based on objective system metrics, while real performance is based on the user's subjective experience.

### --feedback--

Think about how a website can be technically fast but feel slow to a user.

## --video-solution--

2

## --text--

Why is it important to optimize for both real and perceived performance?

## --answers--

To improve search engine rankings.

### --feedback--

Think about the overall impact of performance on website success.

---

To reduce server costs.

### --feedback--

Think about the overall impact of performance on website success.

---

To enhance the user experience.

---

To make websites more accessible.

### --feedback--

Think about the overall impact of performance on website success.

## --video-solution--

3

## --text--

Which of the following techniques can help improve perceived performance?

## --answers--

Using large images.

### --feedback--

Think about how to reduce initial load time and improve perceived responsiveness.

---

Loading all JavaScript files at once.

### --feedback--

Think about how to reduce initial load time and improve perceived responsiveness.

---

Using lazy loading for non-essential resources.

---

Avoiding browser caching.

### --feedback--

Think about how to reduce initial load time and improve perceived responsiveness.

## --video-solution--

3
