---
id: 67d2f6cea4916d78d5a27ad3
title: How to Measure and Improve INP?
challengeType: 19
dashedName: how-to-measure-and-improve-inp
---

# --description--

Let's walk through a practical way to measure Interaction to Next Paint, or INP, using Chrome DevTools.

First of all, let's open DevTools by pressing "F12" or Right-click and click on "Inspect".

Now, let's say you have a search bar on your webpage.

Imagine a user types a query, but it takes 600ms before the suggestion dropdown appears. Chrome DevTools would mark this high INP value.

You can optimize by deferring heavy JavaScript, reducing long tasks, and improving event handling. The INP would then drop to 150ms, making interactions feel instant.

Cool, right?

Now, let's look at a practical measurement technique that helps identify interaction delays so you can create a faster and smoother user experience!

First, we would open Chrome DevTools. We would do so, once again, by opening Google Chrome, navigating to a webpage that we want to analyze, and pressing "F12" or right-clicking the page and clicking "Inspect". Now, let's head to the "Performance" tab - and there is everything that you need.

Now we are ready to identify the Interaction to Next Paint, or INP. We are going to look for the longest interaction delay recorded. A good INP is generally below 200ms, and a poor INP is above 500ms. And that's it!

# --questions--

## --text--

How do you open Chrome DevTools?

## --answers--

By pressing "F12" or Right-clicking and selecting "Inspect".

---

By typing "DevTools" in the browser search bar.

### --feedback--

Think about the easiest way to access developer tools in Chrome.

---

By clicking on the Chrome settings menu.

### --feedback--

Think about the easiest way to access developer tools in Chrome.

---

By installing a separate software.

### --feedback--

Think about the easiest way to access developer tools in Chrome.

## --video-solution--

1

## --text--

What does a high INP value indicate?

## --answers--

The webpage loads quickly.

### --feedback--

Consider what happens when you click something and have to wait for a response.

---

There is a delay between a user interaction and the visual update.

---

The browser has cached all resources efficiently.

### --feedback--

Consider what happens when you click something and have to wait for a response.

---

The webpage does not have any JavaScript.

### --feedback--

Consider what happens when you click something and have to wait for a response.

## --video-solution--

2

## --text--

Which of the following is NOT a way to improve INP?

## --answers--

Reducing main thread work.

### --feedback--

One of these options makes performance worse instead of better.

---

Using `requestIdleCallback()` for non-critical scripts.

### --feedback--

One of these options makes performance worse instead of better.

---

Adding more large images and scripts to the page.

---

Deferring or lazy-loading heavy assets.

### --feedback--

One of these options makes performance worse instead of better.

## --video-solution--

3
