---
id: 67d2f778a856c37bd31c5022
title: What Are Some Key Metrics for Measuring Performance?
challengeType: 19
dashedName: what-are-some-key-metrics-for-measuring-performance
---

# --description--

To measure and improve web performance, we use key performance metrics like First Contentful Paint (or FCP), Speed Index, Total Blocking Time (or TBT), Bounce Rate, and Unique Users. Let's look at all of these metrics individually.

First Contentful Paint, or FCP. This measures how quickly the first piece of content, like a text or image, appears on the screen. A good FCP is regarded as a time below 1.8 seconds, and a poor FCP is usually above 3 seconds. You can check your FCP using Chrome DevTools like this:

Step 1: Open Chrome DevTools

- Open Google Chrome.

- Go to the webpage you want to test.

- Press "F12" or Right-click and "Inspect".

Step 2: Find and click the "Lighthouse" tab in the DevTools.

Step 3: Click the "Analyze page load" button and wait for the analyzation to finish.

Now we can analyze the results. We do this by scrolling down to the "Metrics" section and looking for the "First Contentful Paint" marker. We can see the exact time in milliseconds or seconds.

FCP and Interaction to Next Paint (or INP), that we looked at previously, are both performance metrics, but they measure different aspects of user experience. It's important not to get them mixed up.

As a reminder, FCP is about how fast users see content after loading, and INP is about how fast users see feedback after clicking or typing.

Next we have the Speed Index.

Speed Index measures how quickly visible parts of the page are painted. Lower scores mean better performance! You can check your Speed Index in the Lighthouse Reports.

We also have Total Blocking Time or TBT. This shows how long the main thread is blocked by heavy JavaScript tasks. If TBT is high, users experience laggy interactions. To improve TBT, break up long tasks and defer non-essential scripts.

Next we have the Bounce Rate. This is the percentage of visitors who leave without interacting. If your site has high bounce rates, it might be because your page is too slow.

And finally we have unique users. This metric tracks how many individual visitors come to your site. To view the bounce rate and unique users, you can use Google Analytics. It will allow you to monitor these metrics and improve engagement.

# --questions--

## --text--

What does First Contentful Paint (FCP) measure?

## --answers--

How quickly the entire page loads.

### --feedback--

Think about when a user first sees something on the screen.

---

When the first visible content appears.

---

How many users visit the page.

### --feedback--

Think about when a user first sees something on the screen.

---

The total time a page takes to load.

### --feedback--

Think about when a user first sees something on the screen.

## --video-solution--

2

## --text--

Which metric tracks how quickly a page visually loads?

## --answers--

Bounce Rate.

### --feedback--

It measures how fast content appears, not just how many visitors you get.

---

Total Blocking Time.

### --feedback--

It measures how fast content appears, not just how many visitors you get.

---

Speed Index.

---

Unique Users.

### --feedback--

It measures how fast content appears, not just how many visitors you get.

## --video-solution--

3

## --text--

What can cause a high Total Blocking Time (TBT)?

## --answers--

Excessive DOM manipulation causing layout recalculations.

### --feedback--

Think about what slows down user interactions.

---

Too many large images slowing down the page load.

### --feedback--

Think about what slows down user interactions.

---

Long JavaScript tasks blocking the main thread.

---

Using a simple CSS file with multiple selectors and high specificity.

### --feedback--

Think about what slows down user interactions.

## --video-solution--

3
