---
id: 67d2f80313efe77e43182e86
title: What Are Some Techniques for Improving JavaScript Performance?
challengeType: 19
dashedName: what-are-some-techniques-for-improving-javascript-performance
---

# --description--

Let's review some of the most important techniques for improving JavaScript performance specifically.

You may find this surprising, but the first technique is using less JavaScript whenever possible.

If you're developing a simple static website, you may be able to do exactly the same without frameworks that rely on JavaScript.

You should also try to remove any unused JavaScript code and use simpler solutions, if possible.

For example, you may consider using built-in browser features instead of custom ones. These built-in browser features include form validation, the browser's built-in video player, and CSS animations instead of custom JavaScript animations.

Use as few animations as possible.

Reduce the amount of DOM manipulation on your JavaScript code, since this is computationally expensive.

Splitting your JavaScript code into modules that perform critical and non-critical tasks is also helpful. This way, you'll be able to preload the critical ones as soon as possible and defer the non-critical ones to render the page as fast as possible.

Pre-loading files does not guarantee that they will be available when you use them, but the download will start sooner, so the overall waiting time should be shorter.

Once your code is split into multiple files, you can minify them automatically during the build process to reduce their size and optimize their load time.

If an event listener is no longer necessary, you should remove it:

```js
element.removeEventListener("mousemove", handleMouseMove);
```

In this example, we remove the event listener for the `mousemove` event, so the `handleMouseMove` function is no longer called when the event is triggered. If you keep the event listener, the program will continue performing calculations that are no longer necessary, affecting the overall performance. This effect will be even more noticeable if you have multiple active event listeners simultaneously.

And since we're on the topic of events, it's recommended to use event delegation whenever possible.

This means that you don't need to set the event listeners on individual child elements. You can set it directly on the parent and the event will bubble up until it finds a parent that can handle it.

Optimizing JavaScript is crucial for developing fast and responsive web applications. In a real-world project, you'll constantly analyze the performance of your website to find areas for improvement.

# --questions--

## --text--

What is the primary benefit of minifying JavaScript files?

## --answers--

Improved readability of the JavaScript code.

### --feedback--

Think about how minification affects the size of the JavaScript file.

---

Enhanced security for the website.

### --feedback--

Think about how minification affects the size of the JavaScript file.

---

Faster website loading times.

---

Better cross-browser compatibility.

### --feedback--

Think about how minification affects the size of the JavaScript file.

## --video-solution--

3

## --text--

What is the impact of using too many event listeners on performance?

## --answers--

It can improve performance by making the code more responsive.

### --feedback--

Think about how event listeners can affect the browser's event loop.

---

It can degrade performance by consuming more memory and CPU resources.

---

It has no impact on performance.

### --feedback--

Think about how event listeners can affect the browser's event loop.

---

It can make the code more complex and harder to maintain.

### --feedback--

Think about how event listeners can affect the browser's event loop.

## --video-solution--

2

## --text--

What is the goal of preloading critical JavaScript files and deferring non-critical JavaScript files?

## --answers--

To improve the initial page load time.

---

To reduce the number of HTTP requests.

### --feedback--

Think about how to prioritize the loading of essential JavaScript files.

---

To minify the JavaScript code.

### --feedback--

Think about how to prioritize the loading of essential JavaScript files.

---

To optimize the order of CSS styles

### --feedback--

Think about how to prioritize the loading of essential JavaScript files.

## --video-solution--

1
