---
id: 67d2ff6f069dce9feacb7d25
title: What Is Compatibility Testing?
challengeType: 19
dashedName: what-is-compatibility-testing
---

# --description--

When you build out web applications at scale, you will need to think beyond your personal computing environment. How will these applications work on a variety of devices, operating systems, and browsers? Well, this is where compatibility testing comes in.

The goal of compatibility testing is to see how well your software works in a variety of different computing environments. This provides the team with the ability to catch bugs before they reach production and will help contribute to a smoother product launch.

Different types of compatibility testing include backwards and forwards compatibility, hardware testing, operating systems, networks, browsers, and mobile devices.

Let's take a look at each of the types in more detail by starting with backwards and forwards compatibility. Backwards compatibility refers to when current software is compatible with earlier versions. Forwards compatibility is when software and systems will work with future versions of itself.

The next type of testing is for hardware. Hardware compatibility testing focuses on the software's ability to work properly in different hardware configurations. This includes different types of processors, memory, storage, and graphics cards.

Another type of compatibility testing is for operating systems. You don't want to design software that works smoothly on Mac devices but has bugs on Windows or vice versa. You also need to consider Linux distributions like Ubuntu and Fedora.

The next type of testing is network compatibility testing. You will have users working with different network speeds, protocols, security settings, and more. Therefore, software teams will need to be mindful of all of those different conditions when testing.

Then, there's browser compatibility testing. There are a few popular browsers in the market like Google Chrome, Safari, Firefox, and more. Since all browsers work slightly differently, it's important to test your web application thoroughly and make sure your web applications work consistently across many browsers.

The last type of testing is mobile testing. There was a time in web development when most developers didn't think about testing for mobile devices. This was because, in the early 2000s, mobile devices weren't nearly as powerful or widely used as they are today. But now, tens of millions of people visit websites on phones and tablets. So, it is important to ensure that your software applications work on a variety of Android and iOS devices.

Those are just a few types of testing that you will need to consider when building out your applications. While this might seem like a lot of extra work, it is important to perform compatibility tests because you do want to ensure that your applications work in a variety of computing environments.

# --questions--

## --text--

What is the main goal of compatibility testing?

## --answers--

To ensure that your applications have no accessibility errors.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

To ensure that your applications are free from linting and formatting errors.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

To ensure that your applications work in a variety of computing environments.

---

To ensure that your applications only work for different Linux distributions.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

## --video-solution--

3

## --text--

Which of the following refers to when current software is compatible with earlier versions?

## --answers--

CPU compatibility

### --feedback--

Think about how software will work with older versions.

---

Accessible compatibility

### --feedback--

Think about how software will work with older versions.

---

Forwards compatibility

### --feedback--

Think about how software will work with older versions.

---

Backwards compatibility

## --video-solution--

4

## --text--

Which of the following is NOT typically targeted in compatibility testing?

## --answers--

Mobile operating systems

### --feedback--

One of these options refers to computer memory.

---

RAM size

---

Hardware configuration

### --feedback--

One of these options refers to computer memory.

---

Network environments

### --feedback--

One of these options refers to computer memory.

## --video-solution--

2
