---
id: 67db31349f3ace2c5c803c33
title: What Are BDD and TDD?
challengeType: 19
dashedName: what-are-bdd-and-tdd
---

# --description--

There are two types of testing approaches that you should be aware of in software development. Those approaches are TDD (Test-Driven Development) and BDD (Behavior-Driven Development).

Let's first take a look at TDD. Test-Driven Development is a methodology that emphasizes writing tests first before building out the features for an application.

Here is the typical process for TDD:

1. Write a test

2. Ensure that it fails

3. Write the code for that test

4. Ensure that the test passes this time

5. Make any necessary refactors to the code

Repeat steps 1-5.

Writing tests before building out features provides real-time feedback to developers during the development process. It also helps with catching bugs earlier on in the development stage.

While some software teams will choose to follow the TDD approach, TDD is a polarizing topic in the industry. You will find tons of articles and videos out there both advocating for or bashing TDD. Regardless of how you feel about this approach, it is important to be aware of it because you might come across it in real-world scenarios.

The second testing approach we will take a look at is Behavior-Driven Development (BDD). Behavior-Driven Development is the approach of aligning a series of tests with business goals. These tests should be written in a language that can be understood by both technical and non-technical individuals.

When testing for specific behaviors in a software application, BDD commonly uses the Gherkin language, which is used in businesses to describe behaviors and scenarios. The Gherkin language uses Given, When, and Then statements when describing scenarios.

Here is an example:

**Scenario:** Creating a New Blog Post

**Given** the user is logged into their account and is on the "Create New Post" page,

**When** the user enters a title and content for the post and clicks the "Publish" button,

**Then** the blog post should be saved and displayed on the homepage with the correct title, content, and timestamp.

You first want to define a scenario. Example scenarios include when a user logs into an application or places an order on a website. In this example, the scenario is for a user creating a new blog post on a site.

After the scenario is defined, you should start with a Given statement. This provides context for where the user is starting before performing an action. The When statement is used to represent the action taken by the user.

Finally, the Then statement is used to represent the desired outcome from the previous action taken by the user. Once you define all of your scenarios, you can write tests for each scenario.

Examples of BDD testing frameworks include Cucumber, JBehave, and SpecFlow.

# --questions--

## --text--

What does TDD stand for?

## --answers--

Tab-Driven Development

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Test-Driven Development

---

Table-Driven Development

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

TCP-Driven Development

### --feedback--

Refer to the beginning of the lesson where this was discussed.

## --video-solution--

2

## --text--

What does BDD stand for?

## --answers--

Babel-Driven Development

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Byte-Driven Development

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

Behavior-Driven Development

---

Backend-Driven Development

### --feedback--

Refer to the beginning of the lesson where this was discussed.

## --video-solution--

3

## --text--

Which of the following languages is used in businesses to describe behaviors and scenarios?

## --answers--

Gherkin

---

Rust

### --feedback--

Refer to the end of the lesson where this was discussed.

---

Chai

### --feedback--

Refer to the end of the lesson where this was discussed.

---

JUnit

### --feedback--

Refer to the end of the lesson where this was discussed.

## --video-solution--

1
