---
id: 67db3238375ff8340ee1ff90
title: What Is A/B Testing?
challengeType: 19
dashedName: what-is-ab-testing
---

# --description--

Most of you have a select group of websites that you visit every day. This might include sites like X, Discord, or freeCodeCamp. But have you ever wondered why you often see small changes to the design of your most frequently visited pages? Well, this doesn't happen by accident.

Companies spend a lot of time analyzing analytics and studying user behavior. They do this to identify pain points in the user experience for their site or application. These companies then use that data to come up with solutions to create a smoother user experience.

One of the techniques companies employ is called A/B testing. This type of testing involves comparing two versions of a page or application and studying which version performs better. Sometimes, this type of testing is known as bucket or split testing.

Let's take a look at an example so you can better understand the concept. Imagine you have a landing page with some introductory text and a CTA (call to action) button. Remember that a CTA button is used to encourage users to perform a specific action, like donate or log in.

As you go through the site analytics, you realize that the click-through rate for the CTA is low. So you try redesigning that button so it's more prominent on the page. You increase the size of the button and change the button color from blue to green. To actually see if those changes made a difference, you can use A/B testing.

You can randomly divide your users into two groups. Group A is the control group, which sees the original version of the page with the  smaller blue button, while group B is the experimental group, which see the new version of the page with the larger green button. If the new version of the page results in a higher click-through rate, then you can confidently replace the old button styling with the new one.

Examples of tools to use for A/B testing include GrowthBook and LaunchDarkly.

There are many common use cases for A/B testing like testing ads, email campaigns, or new product features. A/B testing allows you to make more data-driven decisions and continually improve the user experience.

# --questions--

## --text--

What is A/B testing?

## --answers--

This test compares two versions of a page or application and studies which version performs better.

---

This test checks that each unit of code is working correctly.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

This test checks for any accessibility errors in your applications and automatically applies suggestions for fixes.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

---

This test sees how compatible your application is with different operating systems.

### --feedback--

Refer to the beginning of the lesson where this was discussed.

## --video-solution--

1

## --text--

What is one benefit of using A/B testing?

## --answers--

This allows you to make more impulsive decisions as well as continually redesign your website.

### --feedback--

Refer to the end of the lesson where this was discussed.

---

This allows you to ensure there are no linting or formatting errors in your code.

### --feedback--

Refer to the end of the lesson where this was discussed.

---

This allows you to make more data driven decisions as well as continually improve the user experience.

---

This ensures that your applications will run 10x faster in Linux and Mac environments.

### --feedback--

Refer to the end of the lesson where this was discussed.

## --video-solution--

3

## --text--

Which of the following is NOT a common use case for using A/B testing?

## --answers--

New features

### --feedback--

One of these options is an internal change and will have no effect on user experience.

---

Ads

### --feedback--

One of these options is an internal change and will have no effect on user experience.

---

API failures

---

Email campaigns

### --feedback--

One of these options is an internal change and will have no effect on user experience.

## --video-solution--

3
