---
id: 670838977810401844af6fe0
title: What Is the Role of the Link Element in HTML, and How Can It Be Used to Link to External Stylesheets?
challengeType: 19
dashedName: what-is-the-role-of-the-link-element-in-html
---

# --description--

Let's learn about the `link` element, and how to use it to link to external stylesheets.

The `link` element is used to link to external resources like stylesheets and site icons. Here is the basic syntax for using the `link` element for an external CSS file:

```html
<link rel="stylesheet" href="./styles.css" />
```

The `rel` attribute is used to specify the relationship between the linked resource and the HTML document. In this situation, we need to specify that this linked resource is a `stylesheet`.

It is considered best practice to separate your HTML and CSS in different files. Developers will use the `link` element for their external CSS file instead of writing everything in the HTML document.

The `href` attribute is used to specify the location of the URL for the external resource. 

The `dot` followed by a forward slash in the example tells the computer to look in the current folder, or directory, for the `styles.css` file.

The `link` element should be placed inside the `head` element as seen in the following example:

```html
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Examples of the link element</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
```

Often times you will see multiple `link` elements inside a professional codebase that link to different stylesheets, fonts, and icons. Here is an example of using the `link` element to link to an external Google Font called *Playwright Cuba*:

```html
<link rel="preconnect" href="https://fonts.googleapis.com" />
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
<link
  href="https://fonts.googleapis.com/css2?family=Playwrite+CU:wght@100..400&display=swap"
  rel="stylesheet"
/>
```

Google Fonts are a set of free and open source custom fonts that you can use inside any project. You can choose which fonts you would like to use and Google will provide you with the necessary HTML and CSS code. In this example, the `preconnect` value for the `rel` attribute tells the browser to create an early connection to the value specified in the `href` attribute. This is done to speed up loading times for these external resources.

Another common use case for the `link` element is to link to icons. Here is an example of linking to a favicon:

```html
<link rel="icon" href="favicon.ico" />
```

A favicon, which is short for favorite icon, is a small icon typically displayed in the browser tab next to the site title. A lot of websites will use a favicon to display their brand icon.

# --questions--

## --text--

What is the role of the `link` element in HTML?

## --answers--

It specifies the content type of the linked resource.

### --feedback--

Pay close attention to the name of this element because it will give you clue as to what it does.

---

It determines the visibility of the linked resource on the webpage.

### --feedback--

Pay close attention to the name of this element because it will give you clue as to what it does.

---

It defines the font size of the linked resource when displayed.

### --feedback--

Pay close attention to the name of this element because it will give you clue as to what it does.

---

It is used to link to external resources like stylesheets and site icons.

## --video-solution--

4

## --text--

What is the role of the `rel` attribute inside the `link` element?

## --answers--

It is used to indicate the language of the linked document.

### --feedback--

The `rel` attribute represents a relationship.

---

It is used to specify the relationship between the linked resource and the HTML document.

---

It is used to define the media type of the linked document.

### --feedback--

The `rel` attribute represents a relationship.

---

It is used to determine the size of the linked document.

### --feedback--

The `rel` attribute represents a relationship.

## --video-solution--

2

## --text--

What is a favicon?

## --answers--

A type of JavaScript file used to enhance website functionality.

### --feedback--

Look closely at the name since it will imply what a favicon is.

---

A type of font used to style text on a website.

### --feedback--

Look closely at the name since it will imply what a favicon is.

---

A small icon typically displayed in the browser tab next to the site title.

---

A security feature used to prevent cross-site scripting attacks.

### --feedback--

Look closely at the name since it will imply what a favicon is.

## --video-solution--

3
