---
id: 670838e914096b194b0c51aa
title: What Is an HTML Boilerplate, and Why Is It Important?
challengeType: 19
dashedName: what-is-an-html-boilerplate
---

# --description--

Let's learn about the HTML boilerplate.

What is the HTML boilerplate, you ask? It's like a ready-made template for your webpages. Think of it as the foundation of a house. A boilerplate includes the basic structure and essential elements every HTML document needs. It saves you time and helps ensure your pages are set up properly. Here is an example:

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8" />
    <meta
       name="viewport"
       content="width=device-width, initial-scale=1.0" />
    <title>freeCodeCamp</title>
    <link rel="stylesheet" href="./styles.css" />
  </head>
  <body>
  </body>
</html>
```

Let's break down the key parts of this boilerplate. First, there is the `DOCTYPE` declaration:

```html
<!DOCTYPE html>
```

It tells browsers which version of HTML you're using. Next, comes the `html` tag:

```html
<!DOCTYPE html>
<html lang="en">
  <!--All other elements go inside here-->
</html>
```

This wraps around all your content, and can specify the language of your page. Inside the `html` tag, you'll find two main sections - a `head`, and a `body`:

```html
<!DOCTYPE html>
<html lang="en">
  <head>
    <!--Important metadata goes here-->
  </head>
  <body>
    <!--Headings, paragraphs, images, etc. go inside here-->
  </body>
</html>
```

The `head` section contains important behind-the-scenes information:

```html
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Document Title Goes Here</title>
  <link rel="stylesheet" href="./styles.css" />
</head>
```

Your site's metadata, contained in `meta` elements, has details about things like character encoding, and how websites like Twitter should preview your page's link. Your site's title, found in the `title` element, determines the text that appears in the browser tab or window. Finally, you'll typically link your page's external stylesheets in the `head` section using `link` elements.

The `body` section is where all your content goes:

```html
<body>
  <h1>I am a main title</h1>
  <p>Example paragraph text</p>
</body>
```

Now, why is a boilerplate important? It ensures your pages are structured correctly and work well across different browsers. Using a boilerplate helps you avoid common mistakes and follow best practices. It's a great starting point for any web project. Remember, you can customize your own boilerplate to fit your needs. As you gain experience, you might add your own preferred elements or `meta` tags. As you continue to improve your personal boilerplate, you'll find that it saves you time when starting new projects.

Next time you start a new HTML file, consider using a boilerplate. It will definitely give you a solid foundation to build on.

# --questions--

## --text--

Where would you set the character encoding for your page?

## --answers--

A `meta` element in the `body`.

### --feedback--

Character encoding is metadata information.

---

A `head` element in the `body`.

### --feedback--

Character encoding is metadata information.

---

A `meta` element in the `head`.

---

In the `DOCTYPE`.

### --feedback--

Character encoding is metadata information.

## --video-solution--

3

## --text--

Where would you set the language for your page?

## --answers--

In the opening `html` tag.

---

A `meta` element in the `body`.

### --feedback--

This is an attribute on the outer-most element.

---

A `head` element in the `body`.

### --feedback--

This is an attribute on the outer-most element.

---

A `meta` element in the `head`.

### --feedback--

This is an attribute on the outer-most element.

## --video-solution--

1

## --text--

What purpose does a boilerplate serve?

## --answers--

Provides a starting structure for your websites.

### --feedback--

A boilerplate is helpful in many ways.

---

Ensures you are not missing any essential elements.

### --feedback--

A boilerplate is helpful in many ways.

---

Allows you to get started writing the content of your page faster.

### --feedback--

A boilerplate is helpful in many ways.

---

All of the above.

## --video-solution--

4
