---
id: 67fe8597975ea634042cad8f
title: How Do You Declare Variables and What Are Naming Conventions to Name Variables?
challengeType: 19
dashedName: how-do-you-declare-variables-and-what-are-naming-conventions-to-name-variables
---

# --description--

In Python, variables are like a labelled box for storing and referencing data of different types. To declare variables in Python, you assign a value to an identifier with the assignment (`=`) operator. You don't need to use special keywords like `let` or `const` in JavaScript, or `char` in C#.

In Python, you just write the name of the variable on the left, followed by the assignment operator, and the value you want to assign the variable on the right. Here's an example of how to declare `name` and `age` variables:

```python
name = 'John Doe'
age = 25
```

In the example above, the variable `name` holds the value `'John Doe'`. This value is a string, which is a series of characters used to represent text. Strings are written with single or double quotes, for example `'Hello'` or `"Hello"`. In future lessons, you'll learn more about working with strings in Python.

When naming variables in Python, there are some important rules you should keep in mind:

- Variable names can only start with a letter or an underscore (`_`), not a number.
- Variable names can only contain alphanumeric characters (`a-z`, `A-Z`, `0-9`) and underscores (`_`).
- Variable names are case-sensitive — `age`, `Age`, and `AGE` are all considered unique.
- Variable names cannot be one of Python's reserved keywords such as `if`, `class`, or `def`.

If you break any of those rules, your Python program will throw a `SyntaxError`:

```bash
    5variable_name = 5
     ^
SyntaxError: invalid syntax
```

Now let's go over some common naming conventions for variables in Python.

First, variables names should be in lowercase, with separate words separated by an underscore. This is called snake case:

```python
my_variable_name = 'freeCodeCamp'
```

Next, you should use descriptive names for variables. For example, if you want to save a user's age as a variable, `user_age` is better than `age` or an abbreviation like `ua`:

```python
user_age = 30
```

This way, you can easily communicate the purpose of a variable to other team members (or to your future self) in a large codebase.

Another convention is to avoid using single-letter variable names. This is very common in Python, but should be avoided because variable names with a single letter communicate no purpose or meaning:

```python
x = 56 # What do you mean by x?
```

This is different if you are in a loop or something similar, as variable names like `i`, `j`, `k`, and so on are common and acceptable.

Also, the pound symbol (`#`) and the text that follows in the example above is called a comment. You might already be familiar with comments, so let's go over them quickly and explain how they work.

In Python, comments start with a pound symbol (`#`), and the language ignores everything after the `#` symbol on that line:

```python
# This is a single-line comment
```

Multi-line comments can be created by using consecutive single-line comments:

```python
# This is a
# multi-line
# comment
```

You can use comments to explain your code, leave reminders for yourself, or clarify why a line exists. Comments are especially helpful when you're learning or working in teams.

However, you shouldn't use comments to explain what your variable names mean. Instead, the names you choose for your variables should be descriptive and communicate what they're for, and follow the other naming rules mentioned earlier to prevent syntax errors.

# --questions--

## --text--

Which of the following is the correct way to declare a variable in Python?

## --answers--

`let age = 25`

### --feedback--

Python doesn't require keywords for variable declaration.

---

`const age = 25`

### --feedback--

Python doesn't require keywords for variable declaration.

---

`var age = 25`

### --feedback--

Python doesn't require keywords for variable declaration.

---

`age = 25`

## --video-solution--

4

## --text--

Which of these is **not** a rule for naming variables?

## --answers--

Variable names must start with a letter or an underscore.

### --feedback--

Python treats uppercase and lowercase letters as different.

---

Variable names are case-insensitive.

---

Variable names cannot use Python reserved keywords.

### --feedback--

Python treats uppercase and lowercase letters as different.

---

Variable names can contain letters, numbers, and underscores

### --feedback--

Python treats uppercase and lowercase letters as different.

## --video-solution--

2

## --text--

Why should you avoid using single-letter variable names?

## --answers--

They do not communicate the purpose of the variable.

---

Python does not allow single-letter variable names

### --feedback--

Meaningful variable names improve readability in large codebases.

---

They increase the risk of syntax errors

### --feedback--

Meaningful variable names improve readability in large codebases.

---

They use more memory than longer variable names.

### --feedback--

Meaningful variable names improve readability in large codebases.

## --video-solution--

1
