---
id: 67fe859a00971c34a23abd43
title: What Are Common Data Types in Python and How Do You Get the Type of a Variable?
challengeType: 19
dashedName: what-are-common-data-types-in-python-and-how-do-you-get-the-type-of-a-variable
---

# --description--

Before working with Python variables, it's important to understand data types. A data type describes the kind of value a variable holds. For example, a number, a piece of text, or a list of items. Programming languages use data types so they know how to store and work with different kinds of information.

Python is a dynamically-typed language like JavaScript, meaning you don't need to explicitly declare types for variables. The language knows what data type a variable is based on what you assign to it.

Here are some examples:

```python
name = 'John Doe' # Python knows this is a string
age = 25 # Python knows this is an integer
```

This is in contrast to some statically-typed languages like C#, Java, and C++, where you have to declare types with variables, like this:

```csharp
string name = 'John Doe'
int age = 25
```

The dynamic-typing nature of Python makes coding really fast and more flexible, but it can lead to unexpected bugs because type errors are detected only when a program runs, not when the program compiles.

Since Python determines data types while your program is **running**, type-related mistakes are only discovered at that moment. When a program runs, Python executes your code line by line. If it reaches a line where a certain object is expected to behave in a way it's not able to, Python will stop and show an error.

In contrast, some languages **compile** your program before it runs. Compiling means the computer checks your code in advance and prepares it to run. During this step, those languages can catch type errors before the program even starts.

You don't need to know those languages yet. The important idea is simply:

- **In Python type errors can reveal themselves during execution**, when the program is actually running and using your code.

- **Compiled languages catch type errors during the compile step**, before the program is allowed to run.

Because of this, you might not learn about a type mistake in Python until the program reaches that specific line of code while running.

Here are the most common data types you'll use in Python:

- Integer: A whole number without decimals, for example, `10` or `-5`.

```python
my_integer_var = 10
print('Integer:', my_integer_var) # Integer: 10
```

- Float: A number with a decimal point, like `4.41` or `-0.4`.

```python
my_float_var = 4.50
print('Float:', my_float_var) # Float: 4.5
```

- String: A sequence of characters enclosed in single or double quotation marks like `'Hello world!'`.

```python
my_string_var = 'hello'
print('String:', my_string_var) # String: hello
```

- Boolean: A true or false type, written as `True` or `False`.

```python
my_boolean_var = True
print('Boolean:', my_boolean_var) # Boolean: True
```

- Set: An unordered collection of unique elements, like `{4, 2, 0}`.
 
```python
my_set_var = {7, 5, 8}
print('Set:', my_set_var) # Set: {7, 5, 8}
```

- Dictionary: A collection of key-value pairs enclosed in curly braces, like `{'name': 'John Doe', 'age': 28}`. 

```python
my_dictionary_var = {'name': 'Alice', 'age': 25}
print('Dictionary:', my_dictionary_var) # Dictionary: {'name': 'Alice', 'age': 25}
```

- Tuple: An immutable ordered collection, enclosed in brackets, like `(7, 8, 4)`.

```python
my_tuple_var = (7, 5, 8)
print('Tuple:', my_tuple_var) # Tuple: (7, 5, 8)
```

- Range: A sequence of numbers, often used in loops, for example, `range(5)`.

```python
my_range_var = range(5)
print('Range:', my_range_var) # Range: range(0, 5)
```

- List: An ordered collection of elements that supports different data types.
    
```python
my_list = [22, 'Hello world', 3.14, True]
print(my_list) # [22, 'Hello world', 3.14, True]
```

- None: A special value that represents the absence of a value.

```python
my_none_var = None
print('None:', my_none_var) # None: None
```

To get the data type of a variable, you can use the `type()` function:

```python
my_var_1 = 'Hello world'
my_var_2 = 21

print(type(my_var_1)) # <class 'str'>
print(type (my_var_2)) # <class 'int'>
```

And here's are all the data types covered in this lesson, along with their types in the terminal:

```python
my_integer_var = 10
print(type(my_integer_var))  # <class 'int'>

my_float_var = 4.50
print(type(my_float_var))  # <class 'float'>

my_string_var = 'hello'
print(type(my_string_var))  # <class 'str'>

my_boolean_var = True
print(type(my_boolean_var))  # <class 'bool'>

my_set_var = {7, 5, 8}
print(type(my_set_var))  # <class 'set'>

my_dictionary_var = {'name': 'Alice', 'age': 25}
print(type(my_dictionary_var))  # <class 'dict'>

my_tuple_var = (7, 5, 8)
print(type(my_tuple_var))  # <class 'tuple'>

my_range_var = range(5)
print(type(my_range_var))  # <class 'range'>

my_list = [22, 'Hello world', 3.14, True]
print(type(my_list)) # <class 'list'>

my_none_var = None
print(type(my_none_var))  # <class 'NoneType'>
```

The built-in `isinstance()` function lets you  check if a variable matches a specific data type. It takes in an object and the type you want to check it against, then returns a boolean. Here are some examples:

```python
isinstance('Hello world', str) # True
isinstance(True, bool) # True
isinstance(42, int) # True
isinstance('John Doe', int) # False
```

# --questions--

## --text--

What does it mean that Python is dynamically typed?

## --answers--

You must manually specify the data type of every variable.

### --feedback--

Think about how Python figures out the data type for you.

---

Python does not support different data types.

### --feedback--

Think about how Python figures out the data type for you.

---

Python automatically determines the data type based on the assigned value.

---

Variables in Python cannot change their data type after assignment.

### --feedback--

Think about how Python figures out the data type for you.

## --video-solution--

3

## --text--

What is the difference between the integer and float data types?

## --answers--

Integers can store both positive and negative numbers, while floats can only store positive numbers.

### --feedback--

One has decimals, the other doesn't.

---

Integers are whole numbers without decimals, while floats are numbers with decimal points.

---

Floats take up less memory than integers in Python.

### --feedback--

One has decimals, the other doesn't.

---

Integers can only store numbers up to 1000, while floats have no limit.


### --feedback--

One has decimals, the other doesn't.

## --video-solution--

2

## --text--

How can you check the data type of a variable in Python?

## --answers--

By using the `type()` function, like `type(my_var)`.

---

By checking the variable's value manually.

### --feedback--

There's a built-in function for this.

---

By using the `typeof` function, like `typeof(my_var)`.

---

By converting the variable to a string and analyzing its characters.

### --feedback--

There's a built-in function for this.

## --video-solution--

1
